/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.api.interfaces;

import de.cinovo.cloudconductor.api.enums.UpdateRange;
import de.cinovo.cloudconductor.api.model.AgentOption;
import de.cinovo.cloudconductor.api.model.PackageDiff;
import de.cinovo.cloudconductor.api.model.PackageVersion;
import de.cinovo.cloudconductor.api.model.PackageVersionUpdates;
import de.cinovo.cloudconductor.api.model.Repo;
import de.cinovo.cloudconductor.api.model.SSHKey;
import de.cinovo.cloudconductor.api.model.Service;
import de.cinovo.cloudconductor.api.model.ServiceDefaultState;
import de.cinovo.cloudconductor.api.model.SimplePackageVersion;
import de.cinovo.cloudconductor.api.model.SimpleTemplate;
import de.cinovo.cloudconductor.api.model.Template;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/template")
@Produces(value={"application/json;charset=UTF-8"})
@Consumes(value={"application/json;charset=UTF-8"})
public interface ITemplate {
    @GET
    @RolesAllowed(value={"VIEW_TEMPLATE", "EDIT_TEMPLATE"})
    public Template[] get();

    @GET
    @Path(value="/simple")
    public SimpleTemplate[] getSimpleTemplates();

    @PUT
    @RolesAllowed(value={"EDIT_TEMPLATE"})
    public void save(Template var1);

    @DELETE
    @Path(value="/{template}")
    @RolesAllowed(value={"EDIT_TEMPLATE"})
    public void delete(@PathParam(value="template") String var1);

    @GET
    @Path(value="/{template}")
    @RolesAllowed(value={"VIEW_TEMPLATE", "EDIT_TEMPLATE"})
    public Template get(@PathParam(value="template") String var1);

    @PUT
    @Path(value="/{template}/package/{pkg}")
    @RolesAllowed(value={"EDIT_TEMPLATE"})
    public Template updatePackage(@PathParam(value="template") String var1, @PathParam(value="pkg") String var2);

    @DELETE
    @Path(value="/{template}/package/{pkg}")
    @RolesAllowed(value={"EDIT_TEMPLATE"})
    public Template deletePackage(@PathParam(value="template") String var1, @PathParam(value="pkg") String var2);

    @PUT
    @Path(value="/{template}/package/{pkg}/range/{range}")
    @RolesAllowed(value={"EDIT_TEMPLATE"})
    public Template updatePackage(@PathParam(value="template") String var1, @PathParam(value="pkg") String var2, @PathParam(value="range") UpdateRange var3);

    @PUT
    @Path(value="/{template}/package/{pkg}/version/{version}")
    @RolesAllowed(value={"EDIT_TEMPLATE"})
    public Template updatePackage(@PathParam(value="template") String var1, @PathParam(value="pkg") String var2, @PathParam(value="version") String var3);

    @GET
    @Path(value="/{template}/agentoption")
    @RolesAllowed(value={"VIEW_TEMPLATE", "EDIT_TEMPLATE"})
    public AgentOption getAgentOption(@PathParam(value="template") String var1);

    @PUT
    @Path(value="/{template}/agentoption")
    @RolesAllowed(value={"EDIT_TEMPLATE"})
    public AgentOption saveAgentOption(@PathParam(value="template") String var1, AgentOption var2);

    @GET
    @Path(value="/{template}/sshkeys")
    @RolesAllowed(value={"VIEW_TEMPLATE", "EDIT_TEMPLATE"})
    public SSHKey[] getSSHKeysForTemplate(@PathParam(value="template") String var1);

    @GET
    @Path(value="/{template}/services")
    @RolesAllowed(value={"VIEW_TEMPLATE", "EDIT_TEMPLATE"})
    public Service[] getServicesForTemplate(@PathParam(value="template") String var1);

    @GET
    @Path(value="/{template}/servicedefaultstate")
    @RolesAllowed(value={"VIEW_TEMPLATE", "EDIT_TEMPLATE"})
    public ServiceDefaultState[] getServiceDefaultStates(@PathParam(value="template") String var1);

    @GET
    @Path(value="/{template}/servicedefaultstate/{service}")
    @RolesAllowed(value={"VIEW_TEMPLATE", "EDIT_TEMPLATE"})
    public ServiceDefaultState getServiceDefaultState(@PathParam(value="template") String var1, @PathParam(value="service") String var2);

    @PUT
    @Path(value="/{template}/servicedefaultstate/{service}")
    @RolesAllowed(value={"EDIT_TEMPLATE"})
    public ServiceDefaultState saveServiceDefaultState(@PathParam(value="template") String var1, @PathParam(value="service") String var2, ServiceDefaultState var3);

    @GET
    @Path(value="/{template}/repo")
    @RolesAllowed(value={"VIEW_TEMPLATE", "EDIT_TEMPLATE"})
    public Repo[] getReposForTemplate(@PathParam(value="template") String var1);

    @GET
    @Path(value="/{template}/package/versions")
    @RolesAllowed(value={"VIEW_TEMPLATE", "EDIT_TEMPLATE"})
    public PackageVersion[] getPackageVersionsForTemplate(@PathParam(value="template") String var1);

    @PUT
    @Path(value="/{template}/package/versions")
    @RolesAllowed(value={"EDIT_TEMPLATE"})
    public Template replacePackageVersionsForTemplate(@PathParam(value="template") String var1, List<SimplePackageVersion> var2);

    @GET
    @Path(value="/{template}/package/versions/simple")
    @RolesAllowed(value={"VIEW_TEMPLATE", "EDIT_TEMPLATE"})
    public SimplePackageVersion[] getSimplePackageVersionsForTemplate(@PathParam(value="template") String var1);

    @GET
    @Path(value="/{template}/updates")
    @RolesAllowed(value={"VIEW_TEMPLATE", "EDIT_TEMPLATE"})
    public PackageVersionUpdates getPackageVersionUpdatesForTemplate(@PathParam(value="template") String var1);

    @GET
    @Path(value="/packagediff/{templateA}/{templateB}")
    @RolesAllowed(value={"VIEW_TEMPLATE", "EDIT_TEMPLATE"})
    public PackageDiff[] packageDiff(@PathParam(value="templateA") String var1, @PathParam(value="templateB") String var2);
}

