/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.api.enums;

public enum ServiceState {
    STARTING,
    STARTED,
    IN_SERVICE,
    STOPPING,
    STOPPED,
    RESTARTING_STOPPING,
    RESTARTING_STARTING;

    public static ServiceState[] INFLIGHT_STATES;

    public boolean isStateChangePossible(ServiceState nextState) {
        if (nextState == null) {
            return false;
        }
        switch (this) {
            case STARTING: {
                return nextState == STARTED || nextState == STOPPING;
            }
            case STARTED: {
                return nextState == STOPPING || nextState == RESTARTING_STOPPING || nextState == IN_SERVICE;
            }
            case IN_SERVICE: {
                return nextState == STOPPING || nextState == RESTARTING_STOPPING;
            }
            case STOPPING: {
                return nextState == STOPPED || nextState == STARTING;
            }
            case STOPPED: {
                return nextState == STARTING;
            }
            case RESTARTING_STOPPING: {
                return nextState == RESTARTING_STARTING;
            }
            case RESTARTING_STARTING: {
                return nextState == STARTED;
            }
        }
        return false;
    }

    public ServiceState next() {
        ServiceState current = ServiceState.valueOf(this.name());
        boolean inflight = false;
        for (ServiceState s : INFLIGHT_STATES) {
            if (!s.equals((Object)current)) continue;
            inflight = true;
            break;
        }
        if (inflight) {
            switch (current) {
                case RESTARTING_STARTING: {
                    return STARTED;
                }
                case RESTARTING_STOPPING: {
                    return RESTARTING_STARTING;
                }
                case STARTING: {
                    return STARTED;
                }
                case STOPPING: {
                    return STOPPED;
                }
            }
        }
        return current;
    }

    static {
        INFLIGHT_STATES = new ServiceState[]{STARTING, STOPPING, RESTARTING_STOPPING, RESTARTING_STARTING};
    }
}

