/**
 * 
 */
package de.cinovo.cloudconductor.api.model;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeInfo.As;
import com.fasterxml.jackson.annotation.JsonTypeInfo.Id;

/**
 * Copyright 2015 Taimos GmbH<br>
 * <br>
 *
 * @author thoeger
 * 
 */
@JsonTypeInfo(include = As.PROPERTY, use = Id.CLASS)
public class AdditionalLink {
	
	private Long id;
	private String label;
	private String url;

	/** default constructor */
	public AdditionalLink() {
		// nothing to do
	}

	/**
	 * @param id	link id
	 * @param label	link label
	 * @param url	link url
	 */
	public AdditionalLink(long id, String label, String url) {
		this.id = id;
		this.label = label;
		this.url = url;
	}

	/**
	 * @return the id
	 */
	public Long getId() {
		return this.id;
	}
	
	/**
	 * @param id the id to set
	 */
	public void setId(Long id) {
		this.id = id;
	}
	
	/**
	 * @return the label
	 */
	public String getLabel() {
		return this.label;
	}
	
	/**
	 * @param label the label to set
	 */
	public void setLabel(String label) {
		this.label = label;
	}
	
	/**
	 * @return the url
	 */
	public String getUrl() {
		return this.url;
	}
	
	/**
	 * @param url the url to set
	 */
	public void setUrl(String url) {
		this.url = url;
	}
	
}
