/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.api.interfaces;

import de.cinovo.cloudconductor.api.model.Package;
import de.cinovo.cloudconductor.api.model.PackageStateChanges;
import de.cinovo.cloudconductor.api.model.PackageVersion;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/package")
@Produces(value={"application/json;charset=UTF-8"})
@Consumes(value={"application/json;charset=UTF-8"})
public interface IPackage {
    @GET
    @RolesAllowed(value={"VIEW_CONFIGURATIONS", "EDIT_CONFIGURATIONS"})
    public Response get(@DefaultValue(value="0") @QueryParam(value="page") int var1, @DefaultValue(value="0") @QueryParam(value="per_page") int var2, @Context UriInfo var3);

    @GET
    @Path(value="/{pkg}")
    @RolesAllowed(value={"VIEW_CONFIGURATIONS", "EDIT_CONFIGURATIONS"})
    public Package get(@PathParam(value="pkg") String var1);

    @GET
    @Path(value="/{pkg}/versions")
    @RolesAllowed(value={"VIEW_CONFIGURATIONS", "EDIT_CONFIGURATIONS"})
    public PackageVersion[] getVersions(@PathParam(value="pkg") String var1);

    @GET
    @Path(value="/{pkg}/usage")
    @RolesAllowed(value={"VIEW_CONFIGURATIONS", "EDIT_CONFIGURATIONS"})
    public Map<String, String> getUsage(@PathParam(value="pkg") String var1);

    @GET
    @Path(value="/versions/repo/{repo}")
    @RolesAllowed(value={"VIEW_CONFIGURATIONS", "EDIT_CONFIGURATIONS"})
    public PackageVersion[] getVersionsForRepo(@PathParam(value="repo") String var1);

    @GET
    @Path(value="/changes/{host}")
    @RolesAllowed(value={"VIEW_CONFIGURATIONS", "EDIT_CONFIGURATIONS"})
    public PackageStateChanges getPackageChanges(@PathParam(value="host") String var1);
}

