/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import de.cinovo.cloudconductor.api.interfaces.INamed;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class SimplePackageVersion
implements INamed {
    private String name;
    private String version;
    private Set<String> repos = new HashSet<String>();

    public SimplePackageVersion() {
    }

    public SimplePackageVersion(String name, String version, Collection<String> repos) {
        this.name = name;
        this.version = version;
        this.repos = new LinkedHashSet<String>(repos);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Set<String> getRepos() {
        return this.repos;
    }

    public void setRepos(Set<String> repos) {
        this.repos = repos;
    }

    @JsonIgnore
    public String toString() {
        return this.name + ":" + this.version;
    }

    @JsonIgnore
    public boolean equals(Object obj) {
        if (!(obj instanceof SimplePackageVersion)) {
            return false;
        }
        SimplePackageVersion other = (SimplePackageVersion)obj;
        if (this.name == null || !this.name.equals(other.getName())) {
            return false;
        }
        if (this.version == null) {
            return false;
        }
        return this.version.equals(other.getVersion());
    }

    @JsonIgnore
    public int hashCode() {
        return Objects.hash(this.getName(), this.getVersion());
    }
}

