/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.api.interfaces;

import de.cinovo.cloudconductor.api.model.ConfigDiff;
import de.cinovo.cloudconductor.api.model.ConfigValue;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/config")
@Produces(value={"application/json;charset=UTF-8"})
@Consumes(value={"application/json;charset=UTF-8"})
public interface IConfigValue {
    @GET
    @RolesAllowed(value={"VIEW_CONFIGVALUES", "EDIT_CONFIGVALUES"})
    public String[] getAvailableTemplates();

    @GET
    @Path(value="/{template}")
    @Produces(value={"application/json;charset=UTF-8", "application/x-javaargs", "application/x-javaprops"})
    @RolesAllowed(value={"VIEW_CONFIGVALUES", "EDIT_CONFIGVALUES", "USE_AGENT_API"})
    public ConfigValue[] get(@PathParam(value="template") String var1);

    @DELETE
    @Path(value="/{template}")
    @RolesAllowed(value={"EDIT_CONFIGVALUES"})
    public void deleteForTemplate(@PathParam(value="template") String var1);

    @GET
    @Path(value="/{template}/unstacked")
    @RolesAllowed(value={"VIEW_CONFIGVALUES", "EDIT_CONFIGVALUES", "USE_AGENT_API"})
    @Deprecated
    public ConfigValue[] getUnstacked(@PathParam(value="template") String var1);

    @GET
    @Path(value="/{template}/{service}")
    @Produces(value={"application/json;charset=UTF-8", "application/x-javaargs", "application/x-javaprops"})
    @RolesAllowed(value={"VIEW_CONFIGVALUES", "EDIT_CONFIGVALUES", "USE_AGENT_API"})
    public ConfigValue[] get(@PathParam(value="template") String var1, @PathParam(value="service") String var2);

    @DELETE
    @Path(value="/{template}/{service}")
    @RolesAllowed(value={"EDIT_CONFIGVALUES"})
    public void deleteForService(@PathParam(value="template") String var1, @PathParam(value="service") String var2);

    @GET
    @Path(value="/{template}/{service:.*}/{key}")
    @Produces(value={"application/json;charset=UTF-8", "application/x-javaargs", "application/x-javaprops"})
    @RolesAllowed(value={"VIEW_CONFIGVALUES", "EDIT_CONFIGVALUES", "USE_AGENT_API"})
    public String get(@PathParam(value="template") String var1, @PathParam(value="service") String var2, @PathParam(value="key") String var3);

    @GET
    @Path(value="/{template}/{service:.*}/{key}/exact")
    @Produces(value={"application/json;charset=UTF-8", "application/x-javaargs", "application/x-javaprops"})
    @RolesAllowed(value={"VIEW_CONFIGVALUES", "EDIT_CONFIGVALUES", "USE_AGENT_API"})
    public String getExact(@PathParam(value="template") String var1, @PathParam(value="service") String var2, @PathParam(value="key") String var3);

    @PUT
    @RolesAllowed(value={"EDIT_CONFIGVALUES"})
    public void save(ConfigValue var1);

    @DELETE
    @Path(value="/{template}/{service:.*}/{key}")
    @RolesAllowed(value={"EDIT_CONFIGVALUES"})
    public void delete(@PathParam(value="template") String var1, @PathParam(value="service") String var2, @PathParam(value="key") String var3);

    @GET
    @Path(value="/clean/{template}")
    @RolesAllowed(value={"VIEW_CONFIGVALUES", "EDIT_CONFIGVALUES", "USE_AGENT_API"})
    public ConfigValue[] getClean(@PathParam(value="template") String var1);

    @GET
    @Path(value="/clean/unstacked/{template}")
    @RolesAllowed(value={"VIEW_CONFIGVALUES", "EDIT_CONFIGVALUES", "USE_AGENT_API"})
    public ConfigValue[] getCleanUnstacked(@PathParam(value="template") String var1);

    @GET
    @Path(value="/clean/{template}/{service}")
    @Produces(value={"application/json;charset=UTF-8", "application/x-javaargs", "application/x-javaprops"})
    @RolesAllowed(value={"VIEW_CONFIGVALUES", "EDIT_CONFIGVALUES", "USE_AGENT_API"})
    public ConfigValue[] getClean(@PathParam(value="template") String var1, @PathParam(value="service") String var2);

    @GET
    @Path(value="/clean/{template}/{service:.*}/{key}")
    @Produces(value={"application/json;charset=UTF-8", "application/x-javaargs", "application/x-javaprops"})
    @RolesAllowed(value={"VIEW_CONFIGVALUES", "EDIT_CONFIGVALUES", "USE_AGENT_API"})
    public String getClean(@PathParam(value="template") String var1, @PathParam(value="service") String var2, @PathParam(value="key") String var3);

    @GET
    @Path(value="clean/vars/{template}")
    @Produces(value={"application/json;charset=UTF-8", "application/x-javaargs", "application/x-javaprops"})
    @RolesAllowed(value={"VIEW_CONFIGVALUES", "EDIT_CONFIGVALUES", "USE_AGENT_API"})
    public ConfigValue[] getCleanVars(@PathParam(value="template") String var1);

    @GET
    @Path(value="diff/{templateA}/{templateB}")
    @Produces(value={"application/json;charset=UTF-8", "application/x-javaargs", "application/x-javaprops"})
    @RolesAllowed(value={"VIEW_CONFIGVALUES", "EDIT_CONFIGVALUES"})
    public ConfigDiff[] diffTemplates(@PathParam(value="templateA") String var1, @PathParam(value="templateB") String var2);

    @PUT
    @Path(value="migrate")
    @RolesAllowed(value={"EDIT_CONFIGVALUES"})
    public void migrateGlobalConfig();
}

