/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.api.interfaces;

import de.cinovo.cloudconductor.api.model.PasswordChange;
import de.cinovo.cloudconductor.api.model.User;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/user")
@Produces(value={"application/json;charset=UTF-8"})
@Consumes(value={"application/json;charset=UTF-8"})
public interface IUser {
    @GET
    @RolesAllowed(value={"VIEW_USERS", "EDIT_USERS"})
    public User[] getUsers();

    @PUT
    @RolesAllowed(value={"EDIT_USERS"})
    public void save(User var1);

    @GET
    @Path(value="/{username}")
    @RolesAllowed(value={"VIEW_USERS", "EDIT_USERS"})
    public User getUser(@PathParam(value="username") String var1);

    @DELETE
    @Path(value="/{username}")
    @RolesAllowed(value={"EDIT_USERS"})
    public void delete(@PathParam(value="username") String var1);

    @PUT
    @Path(value="/{username}/authtoken")
    @RolesAllowed(value={"EDIT_USERS"})
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public User createAuthToken(@PathParam(value="username") String var1);

    @DELETE
    @Path(value="/{username}/authtoken/{token}")
    @RolesAllowed(value={"EDIT_USERS"})
    public void revokeAuthToken(@PathParam(value="username") String var1, @PathParam(value="token") String var2);

    @PUT
    @Path(value="/changepassword")
    public void changePassword(PasswordChange var1);
}

