/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import de.cinovo.cloudconductor.api.interfaces.INamed;
import de.cinovo.cloudconductor.api.model.Dependency;
import java.util.HashSet;
import java.util.Set;

@JsonTypeInfo(include=JsonTypeInfo.As.PROPERTY, use=JsonTypeInfo.Id.CLASS)
public class PackageVersion
implements INamed {
    private String name;
    private String version;
    private Set<Dependency> dependencies = new HashSet<Dependency>();
    private Set<String> repos = new HashSet<String>();

    public PackageVersion() {
    }

    public PackageVersion(String name, String version, Set<Dependency> dependencies) {
        this.name = name;
        this.version = version;
        this.dependencies = dependencies;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Set<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(Set<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    public Set<String> getRepos() {
        return this.repos;
    }

    public void setRepos(Set<String> repos) {
        this.repos = repos;
    }

    @JsonIgnore
    public String toString() {
        return this.name + ":" + this.version + " (" + this.repos.toString() + ")";
    }

    @JsonIgnore
    public boolean equals(Object obj) {
        if (!(obj instanceof PackageVersion)) {
            return false;
        }
        PackageVersion other = (PackageVersion)obj;
        if (this.name == null) {
            return false;
        }
        if (!this.name.equals(other.getName())) {
            return false;
        }
        if (this.version == null) {
            return false;
        }
        return this.version.equals(other.getVersion());
    }

    @JsonIgnore
    public int hashCode() {
        int val = this.getVersion() == null ? 0 : this.getVersion().hashCode();
        int parent = this.getName() == null ? 0 : this.getName().hashCode();
        return val * parent;
    }
}

