/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.api.interfaces;

import de.cinovo.cloudconductor.api.model.ChangeServiceState;
import de.cinovo.cloudconductor.api.model.Host;
import de.cinovo.cloudconductor.api.model.SimpleHost;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/host")
@Produces(value={"application/json;charset=UTF-8"})
@Consumes(value={"application/json;charset=UTF-8"})
public interface IHost {
    @GET
    @RolesAllowed(value={"VIEW_HOST", "EDIT_HOST"})
    public Host[] getHosts();

    @GET
    @Path(value="/simple")
    public SimpleHost[] getSimpleHosts();

    @GET
    @Path(value="/{host}")
    @RolesAllowed(value={"VIEW_HOST", "EDIT_HOST"})
    public Host getHost(@PathParam(value="host") String var1);

    @DELETE
    @Path(value="/{host}")
    @RolesAllowed(value={"EDIT_HOST"})
    public void deleteHost(@PathParam(value="host") String var1);

    @PUT
    @Path(value="/changeservicestate")
    @RolesAllowed(value={"EDIT_HOST"})
    public void setServiceState(ChangeServiceState var1);

    @GET
    @Path(value="/{host}/changetemplate/{template}")
    @RolesAllowed(value={"EDIT_HOST"})
    public void moveHost(@PathParam(value="host") String var1, @PathParam(value="template") String var2);
}

