/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.api.lib.helper;

import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class SchedulerService {
    public static SchedulerService instance = new SchedulerService();
    private final ScheduledExecutorService ses = Executors.newScheduledThreadPool(10);
    private final HashMap<String, Runnable> tasks;
    private final HashMap<String, ScheduledFuture<?>> runningTasks = new HashMap();

    private SchedulerService() {
        this.tasks = new HashMap();
    }

    public void register(String identifier, Runnable task, long period, TimeUnit unit) {
        if (!this.tasks.containsKey(identifier)) {
            this.tasks.put(identifier, task);
        }
        if (!this.runningTasks.containsKey(identifier)) {
            this.resetTask(identifier, period, unit);
        }
    }

    public void register(String identifier, Runnable task) {
        if (!this.tasks.containsKey(identifier)) {
            this.tasks.put(identifier, task);
        }
    }

    public ScheduledFuture<?> executeOnce(Runnable task, long delay, TimeUnit unit) {
        return this.ses.schedule(task, delay, unit);
    }

    public ScheduledFuture<?> executeOnce(String identifier) {
        return this.ses.schedule(this.tasks.get(identifier), 0L, TimeUnit.SECONDS);
    }

    public void resetTask(String identifier, long period, TimeUnit unit) {
        if (!this.tasks.containsKey(identifier)) {
            throw new RuntimeException("Unknown task: " + identifier);
        }
        long delay = 0L;
        if (this.runningTasks.containsKey(identifier)) {
            ScheduledFuture<?> task = this.runningTasks.get(identifier);
            delay = task.getDelay(unit);
            task.cancel(false);
        }
        this.runningTasks.put(identifier, this.ses.scheduleAtFixedRate(this.tasks.get(identifier), delay, period, unit));
    }

    public void stop(String identifier) {
        if (!this.tasks.containsKey(identifier)) {
            throw new RuntimeException("Unknown task: " + identifier);
        }
        if (this.runningTasks.containsKey(identifier)) {
            ScheduledFuture<?> task = this.runningTasks.get(identifier);
            task.cancel(false);
            this.runningTasks.remove(identifier);
        }
    }

    public void shutdown() {
        this.ses.shutdown();
    }
}

