/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.api.lib.manager;

import de.cinovo.cloudconductor.api.lib.exceptions.CloudConductorException;
import de.cinovo.cloudconductor.api.lib.helper.AbstractApiHandler;
import de.cinovo.cloudconductor.api.model.PackageState;
import de.cinovo.cloudconductor.api.model.PackageStateChanges;
import de.cinovo.cloudconductor.api.model.SSHKey;
import de.cinovo.cloudconductor.api.model.Service;
import de.cinovo.cloudconductor.api.model.ServiceStates;
import de.cinovo.cloudconductor.api.model.ServiceStatesChanges;
import de.cinovo.cloudconductor.api.model.Template;
import java.util.Set;

public class AgentHandler
extends AbstractApiHandler {
    public AgentHandler(String cloudconductorUrl) {
        super(cloudconductorUrl);
    }

    public PackageStateChanges notifyPackageState(String template, String host, PackageState state) throws CloudConductorException {
        String path = this.pathGenerator("/agent/{template}/{host}/package", template, host);
        return this._put(path, (Object)state, PackageStateChanges.class);
    }

    public ServiceStatesChanges notifyServiceState(String template, String host, ServiceStates state) throws CloudConductorException {
        String path = this.pathGenerator("/agent/{template}/{host}/service", template, host);
        return this._put(path, (Object)state, ServiceStatesChanges.class);
    }

    public String getConfigFileData(String configFilename) throws CloudConductorException {
        String path = this.pathGenerator("/file/{name}/data", configFilename);
        return this._get(path, String.class);
    }

    public Template getTemplate(String template) throws CloudConductorException {
        String path = this.pathGenerator("/templates/{name}", template);
        return this._get(path, Template.class);
    }

    public Set<Service> getServices(String template) throws CloudConductorException {
        String path = this.pathGenerator("/templates/{template}/services", template);
        return (Set)this._get(path, this.getSetType(Service.class));
    }

    public Set<SSHKey> getSSHKeys(String template) throws CloudConductorException {
        String path = this.pathGenerator("/templates/{template}/sshkeys", template);
        return (Set)this._get(path, this.getSetType(SSHKey.class));
    }

    public Set<String> getAliveAgents() throws CloudConductorException {
        String path = this.pathGenerator("/agent", new String[0]);
        return (Set)this._get(path, this.getSetType(String.class));
    }
}

