/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.api.lib.manager;

import de.cinovo.cloudconductor.api.lib.exceptions.CloudConductorException;
import de.cinovo.cloudconductor.api.lib.helper.DefaultRestHandler;
import de.cinovo.cloudconductor.api.model.Package;
import de.cinovo.cloudconductor.api.model.PackageVersion;
import java.util.Set;

public class PackageHandler
extends DefaultRestHandler<Package> {
    public PackageHandler(String cloudconductorUrl) {
        super(cloudconductorUrl);
    }

    @Override
    protected String getDefaultPath() {
        return "/packages";
    }

    @Override
    protected Class<Package> getAPIClass() {
        return Package.class;
    }

    public Set<PackageVersion> getRPMS(String packageName) throws CloudConductorException {
        String path = this.pathGenerator("/{pkg}/versions", packageName);
        return (Set)this._get(path, this.getSetType(PackageVersion.class));
    }

    public void addRPM(String packageName, PackageVersion version) throws CloudConductorException {
        String path = this.pathGenerator("/{pkg}/versions/{version}", packageName, version.getVersion());
        this._put(path, version);
    }

    public void removeRPM(String packageName, String version) throws CloudConductorException {
        String path = this.pathGenerator("/{pkg}/versions/{version}", packageName, version);
        this._delete(path);
    }
}

