/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.api.lib.manager;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.MapType;
import de.cinovo.cloudconductor.api.lib.exceptions.CloudConductorException;
import de.cinovo.cloudconductor.api.lib.helper.AbstractApiHandler;
import de.cinovo.cloudconductor.api.model.KeyValue;
import java.util.HashMap;
import java.util.Map;

public class ConfigValueHandler
extends AbstractApiHandler {
    public ConfigValueHandler(String cloudconductorUrl) {
        super(cloudconductorUrl);
    }

    public Map<String, String> getConfig(String template) throws CloudConductorException {
        String path = this.pathGenerator("/config/{template}", template);
        MapType type = AbstractApiHandler.mapper.getTypeFactory().constructMapType(HashMap.class, String.class, String.class);
        return (Map)this._get(path, (JavaType)type);
    }

    public Map<String, String> getConfig(String template, String service) throws CloudConductorException {
        String path = this.pathGenerator("/config/{template}/{service}", template, service);
        MapType type = AbstractApiHandler.mapper.getTypeFactory().constructMapType(HashMap.class, String.class, String.class);
        return (Map)this._get(path, (JavaType)type);
    }

    public String getConfig(String template, String service, String key) throws CloudConductorException {
        String path = this.pathGenerator("/config/{template}/{service}/{key}", template, service, key);
        return this._get(path, String.class);
    }

    public void addConfig(String template, String key, String value) throws CloudConductorException {
        String path = this.pathGenerator("/config/{template}", template);
        KeyValue kv = new KeyValue(key, value);
        this._put(path, kv);
    }

    public void addConfig(String template, String service, String key, String value) throws CloudConductorException {
        String path = this.pathGenerator("/config/{template}/{service}", template, service);
        KeyValue kv = new KeyValue(key, value);
        this._put(path, kv);
    }

    public void removeConfig(String template, String key) throws CloudConductorException {
        String path = this.pathGenerator("/config/{template}/{key}", template, key);
        this._delete(path);
    }

    public void removeConfig(String template, String service, String key) throws CloudConductorException {
        String path = this.pathGenerator("/config/{template}/{service}/{key}", template, service, key);
        this._delete(path);
    }
}

