/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.api.interfaces;

import de.cinovo.cloudconductor.api.interfaces.IDefaultApi;
import de.cinovo.cloudconductor.api.model.Host;
import de.cinovo.cloudconductor.api.model.PackageVersion;
import de.cinovo.cloudconductor.api.model.SSHKey;
import de.cinovo.cloudconductor.api.model.Service;
import de.cinovo.cloudconductor.api.model.Template;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/templates")
public interface ITemplate
extends IDefaultApi<Template> {
    @GET
    @Path(value="/{template}/services")
    @Produces(value={"application/json;charset=UTF-8"})
    public Service[] getServices(@PathParam(value="template") String var1);

    @GET
    @Path(value="/{template}/hosts")
    @Produces(value={"application/json;charset=UTF-8"})
    public Host[] getHosts(@PathParam(value="template") String var1);

    @PUT
    @Path(value="/{template}/hosts/{host}")
    public void addHost(@PathParam(value="template") String var1, @PathParam(value="host") String var2);

    @DELETE
    @Path(value="/{template}/hosts/{host}")
    public void removeHost(@PathParam(value="template") String var1, @PathParam(value="host") String var2);

    @GET
    @Path(value="/{template}/sshkeys")
    @Produces(value={"application/json;charset=UTF-8"})
    public SSHKey[] getSSHKeys(@PathParam(value="template") String var1);

    @PUT
    @Path(value="/{template}/sshkeys/{name}")
    public void addSSHKey(@PathParam(value="template") String var1, @PathParam(value="name") String var2);

    @DELETE
    @Path(value="/{template}/sshkeys/{name}")
    public void removeSSHKey(@PathParam(value="template") String var1, @PathParam(value="name") String var2);

    @GET
    @Path(value="/{template}/package/versions")
    @Produces(value={"application/json;charset=UTF-8"})
    public PackageVersion[] getRPMS(@PathParam(value="template") String var1);

    @POST
    @Path(value="/{template}/package/versions")
    @Consumes(value={"application/json;charset=UTF-8"})
    public void addRPM(@PathParam(value="template") String var1, PackageVersion var2);

    @DELETE
    @Path(value="/{template}/package/versions/{pkg}/{version}")
    public void removeRPM(@PathParam(value="template") String var1, @PathParam(value="pkg") String var2, @PathParam(value="version") String var3);
}

