/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.api.lib.manager;

import de.cinovo.cloudconductor.api.lib.exceptions.CloudConductorException;
import de.cinovo.cloudconductor.api.lib.helper.DefaultRestHandler;
import de.cinovo.cloudconductor.api.model.Package;
import de.cinovo.cloudconductor.api.model.Service;
import java.util.Set;

public class ServiceHandler
extends DefaultRestHandler<Service> {
    public ServiceHandler(String cloudconductorUrl) {
        super(cloudconductorUrl);
    }

    @Override
    protected String getDefaultPath() {
        return "/services";
    }

    @Override
    protected Class<Service> getAPIClass() {
        return Service.class;
    }

    public Set<Package> getPackages(String service) throws CloudConductorException {
        String path = this.pathGenerator("/{service}/packages", service);
        return (Set)this._get(path, this.getSetType(Package.class));
    }

    public void addPackage(String service, String pkg) throws CloudConductorException {
        String path = this.pathGenerator("/{service}/packages/{pkg}", service, pkg);
        this._put(path);
    }

    public void removePackage(String service, String pkg) throws CloudConductorException {
        String path = this.pathGenerator("/{service}/packages/{pkg}", service, pkg);
        this._delete(path);
    }
}

