/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.api.lib.helper;

import com.fasterxml.jackson.databind.JavaType;
import de.cinovo.cloudconductor.api.lib.exceptions.CloudConductorException;
import de.cinovo.cloudconductor.api.lib.helper.AbstractApiHandler;
import de.cinovo.cloudconductor.api.model.INamed;
import java.util.Set;

public abstract class DefaultRestHandler<T extends INamed>
extends AbstractApiHandler {
    protected DefaultRestHandler(String cloudconductorUrl) {
        super(cloudconductorUrl);
    }

    protected abstract String getDefaultPath();

    protected abstract Class<T> getAPIClass();

    protected JavaType getSetType() {
        return this.getSetType(this.getAPIClass());
    }

    public Set<T> get() throws CloudConductorException {
        return (Set)this._get(this.getDefaultPath(), this.getSetType());
    }

    public void save(T apiObject) throws CloudConductorException {
        String path = this.pathGenerator("/{name}", apiObject.getName());
        this._put(path, apiObject);
    }

    public T get(String name) throws CloudConductorException {
        String path = this.pathGenerator("/{name}", name);
        return (T)((INamed)this._get(path, this.getAPIClass()));
    }

    public void delete(String name) throws CloudConductorException {
        String path = this.pathGenerator("/{name}", name);
        this._delete(path);
    }

    @Override
    protected final String pathGenerator(String path, String ... replace) {
        String s = this.getDefaultPath() + path;
        return super.pathGenerator(s, replace);
    }
}

