/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.api.lib.manager;

import de.cinovo.cloudconductor.api.lib.exceptions.CloudConductorException;
import de.cinovo.cloudconductor.api.lib.helper.DefaultRestHandler;
import de.cinovo.cloudconductor.api.model.Host;
import de.cinovo.cloudconductor.api.model.PackageVersion;
import de.cinovo.cloudconductor.api.model.SSHKey;
import de.cinovo.cloudconductor.api.model.Service;
import de.cinovo.cloudconductor.api.model.Template;
import java.util.Set;

public class TemplateHandler
extends DefaultRestHandler<Template> {
    public TemplateHandler(String cloudconductorUrl) {
        super(cloudconductorUrl);
    }

    public TemplateHandler(String cloudconductorUrl, String token, String agent) {
        super(cloudconductorUrl);
        this.setTokenMode(token, agent);
    }

    @Override
    protected String getDefaultPath() {
        return "/templates";
    }

    @Override
    protected Class<Template> getAPIClass() {
        return Template.class;
    }

    public Set<Host> getHosts(String template) throws CloudConductorException {
        String path = this.pathGenerator("/{template}/hosts", template);
        return (Set)this._get(path, this.getSetType(Host.class));
    }

    @Deprecated
    public void addHost(String template, String host) throws CloudConductorException {
        String path = this.pathGenerator("/{template}/hosts/{host}", template, host);
        this._put(path);
    }

    @Deprecated
    public void removeHost(String template, String host) throws CloudConductorException {
        String path = this.pathGenerator("/{template}/hosts/{host}", template, host);
        this._delete(path);
    }

    public Set<SSHKey> getSSHKeys(String template) throws CloudConductorException {
        String path = this.pathGenerator("/{template}/sshkeys", template);
        return (Set)this._get(path, this.getSetType(SSHKey.class));
    }

    public void addSSHKey(String template, String key) throws CloudConductorException {
        String path = this.pathGenerator("/{template}/sshkeys/{name}", template, key);
        this._put(path);
    }

    public void removeSSHKey(String template, String key) throws CloudConductorException {
        String path = this.pathGenerator("/{template}/sshkeys/{name}", template, key);
        this._delete(path);
    }

    public Set<PackageVersion> getVersions(String template) throws CloudConductorException {
        String path = this.pathGenerator("/{template}/package/versions", template);
        return (Set)this._get(path, this.getSetType(PackageVersion.class));
    }

    public void addVersion(String template, PackageVersion version) throws CloudConductorException {
        String path = this.pathGenerator("/{template}/package/versions", template);
        this._post(path, version);
    }

    public void removeVersion(String template, PackageVersion version) throws CloudConductorException {
        String path = this.pathGenerator("/{template}/package/versions/{pkg}/{version}", template, version.getName(), version.getVersion());
        this._delete(path);
    }

    public Set<Service> getServices(String template) throws CloudConductorException {
        String path = this.pathGenerator("/{template}/services", template);
        return (Set)this._get(path, this.getSetType(Service.class));
    }
}

