/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.api.lib.manager;

import de.cinovo.cloudconductor.api.lib.exceptions.ClientErrorException;
import de.cinovo.cloudconductor.api.lib.exceptions.CloudConductorException;
import de.cinovo.cloudconductor.api.lib.helper.DefaultRestHandler;
import de.cinovo.cloudconductor.api.model.Host;
import de.cinovo.cloudconductor.api.model.Service;
import java.util.Set;

public class HostHandler
extends DefaultRestHandler<Host> {
    public HostHandler(String cloudconductorUrl) {
        super(cloudconductorUrl);
    }

    public HostHandler(String cloudconductorUrl, String token, String agent) {
        super(cloudconductorUrl);
        this.setTokenMode(token, agent);
    }

    @Override
    protected String getDefaultPath() {
        return "/hosts";
    }

    @Override
    protected Class<Host> getAPIClass() {
        return Host.class;
    }

    public Set<Service> getServices(String name) throws CloudConductorException {
        String path = this.pathGenerator("/{host}/services", name);
        return (Set)this._get(path, this.getSetType(Service.class));
    }

    public void setService(String name, Service service) throws CloudConductorException {
        String path = this.pathGenerator("/{host}/services/{service}", name, service.getName());
        this._put(path, service);
    }

    public void removeService(String name, String service) throws CloudConductorException {
        String path = this.pathGenerator("/{host}/services/{service}", name, service);
        this._delete(path);
    }

    public Boolean inSync(String host) throws CloudConductorException {
        String path = this.pathGenerator("/{host}/synced", host);
        return this._get(path, Boolean.class);
    }

    public Boolean startService(String host, String service) throws CloudConductorException {
        String path = this.pathGenerator("/{host}/services/{service}/start", host, service);
        try {
            this._put(path);
            return true;
        }
        catch (ClientErrorException e) {
            return false;
        }
    }

    public Boolean stopService(String host, String service) throws CloudConductorException {
        String path = this.pathGenerator("/{host}/services/{service}/stop", host, service);
        try {
            this._put(path);
            return true;
        }
        catch (ClientErrorException e) {
            return false;
        }
    }

    public Boolean restartService(String host, String service) throws CloudConductorException {
        String path = this.pathGenerator("/{host}/services/{service}/restart", host, service);
        try {
            this._put(path);
            return true;
        }
        catch (ClientErrorException e) {
            return false;
        }
    }
}

