/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.api.lib.manager;

import de.cinovo.cloudconductor.api.lib.exceptions.CloudConductorException;
import de.cinovo.cloudconductor.api.lib.helper.DefaultRestHandler;
import de.cinovo.cloudconductor.api.model.ConfigFile;
import java.util.Set;

public class ConfigFileHandler
extends DefaultRestHandler<ConfigFile> {
    public ConfigFileHandler(String cloudconductorUrl) {
        super(cloudconductorUrl);
    }

    public ConfigFileHandler(String cloudconductorUrl, String token, String agent) {
        super(cloudconductorUrl);
        this.setTokenMode(token, agent);
    }

    @Override
    protected String getDefaultPath() {
        return "/file";
    }

    @Override
    protected Class<ConfigFile> getAPIClass() {
        return ConfigFile.class;
    }

    public String getData(String name) throws CloudConductorException {
        String path = this.pathGenerator("/{name}/data", name);
        return this._get(path, String.class);
    }

    public void saveData(String name, String data) throws CloudConductorException {
        String path = this.pathGenerator("/{name}/data", name);
        this._put(path, data);
    }

    public Set<ConfigFile> getConfigFilesByTemplate(String template) throws CloudConductorException {
        String path = this.pathGenerator("/{template}/files", template);
        return (Set)this._get(path, this.getSetType(ConfigFile.class));
    }
}

