/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.api.lib.helper;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import de.cinovo.cloudconductor.api.lib.exceptions.ClientErrorException;
import de.cinovo.cloudconductor.api.lib.exceptions.CloudConductorException;
import de.cinovo.cloudconductor.api.lib.exceptions.SerializationException;
import de.cinovo.cloudconductor.api.lib.exceptions.ServerErrorException;
import de.cinovo.cloudconductor.api.lib.helper.HttpStatusClass;
import de.cinovo.cloudconductor.api.lib.helper.MapperFactory;
import de.taimos.httputils.HTTPRequest;
import de.taimos.httputils.WS;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.http.HttpResponse;

public abstract class AbstractApiHandler {
    public static final ObjectMapper mapper = MapperFactory.createDefault();
    private static final String VAR_PATTERN = "\\{([a-zA-Z]+)(\\:\\.\\*)?\\}";
    private String serverUrl;
    private String username;
    private String password;
    private String token;
    private String agent;

    protected AbstractApiHandler(String cloudconductorUrl) {
        this.serverUrl = cloudconductorUrl;
    }

    protected final Object _get(String path, JavaType type) throws CloudConductorException {
        HttpResponse response = this.request(path).get();
        AbstractApiHandler.assertSuccess(path, response);
        return this.objectFromResponse(response, type);
    }

    protected final <T> T _get(String path, Class<T> type) throws CloudConductorException {
        HttpResponse response = this.request(path).get();
        AbstractApiHandler.assertSuccess(path, response);
        return this.objectFromResponse(response, type);
    }

    protected final HttpResponse _put(String path) throws CloudConductorException {
        HttpResponse response = this.request(path).put();
        AbstractApiHandler.assertSuccess(path, response);
        return response;
    }

    protected final HttpResponse _put(String path, Object put) throws CloudConductorException {
        HttpResponse response = this.request(path, put).put();
        AbstractApiHandler.assertSuccess(path, response);
        return response;
    }

    protected final <T> T _put(String path, Object put, JavaType type) throws CloudConductorException {
        HttpResponse response = this.request(path, put, type).put();
        AbstractApiHandler.assertSuccess(path, response);
        if (type == null) {
            return null;
        }
        return this.objectFromResponse(response, type);
    }

    protected final <T> T _put(String path, Object put, Class<T> type) throws CloudConductorException {
        HttpResponse response = this._put(path, put);
        if (type == null) {
            return null;
        }
        return this.objectFromResponse(response, type);
    }

    protected final HttpResponse _post(String path, Object post) throws CloudConductorException {
        HttpResponse response = this.request(path, post).post();
        AbstractApiHandler.assertSuccess(path, response);
        return response;
    }

    protected final <T> T _post(String path, Object post, JavaType type) throws CloudConductorException {
        HttpResponse response = this.request(path, post, type).post();
        AbstractApiHandler.assertSuccess(path, response);
        if (type == null) {
            return null;
        }
        return this.objectFromResponse(response, type);
    }

    protected final <T> T _post(String path, Object post, Class<T> type) throws CloudConductorException {
        HttpResponse response = this._post(path, post);
        if (type == null) {
            return null;
        }
        return this.objectFromResponse(response, type);
    }

    protected final void _delete(String path) throws CloudConductorException {
        HttpResponse response = this.request(path).delete();
        AbstractApiHandler.assertSuccess(path, response);
    }

    protected final <T> T objectFromResponse(HttpResponse response, Class<T> type) throws SerializationException {
        try {
            return (T)mapper.readValue(WS.getResponseAsString((HttpResponse)response), type);
        }
        catch (IOException e) {
            throw new SerializationException("Failed to read object", e);
        }
    }

    public final <T> T objectFromResponse(HttpResponse response, JavaType type) throws SerializationException {
        try {
            String value = WS.getResponseAsString((HttpResponse)response);
            if (value.isEmpty()) {
                return null;
            }
            return (T)mapper.readValue(value, type);
        }
        catch (IOException e) {
            throw new SerializationException("Failed to read object", e);
        }
    }

    protected final String dataFromResponse(HttpResponse response) {
        return WS.getResponseAsString((HttpResponse)response);
    }

    protected final HTTPRequest request(String path) {
        if (this.username != null && this.password != null) {
            return WS.url((String)(this.serverUrl + path)).authBasic(this.username, this.password);
        }
        if (this.token != null) {
            return WS.url((String)(this.serverUrl + path)).auth("TOKEN " + this.token + "_" + this.agent);
        }
        return WS.url((String)(this.serverUrl + path));
    }

    protected final HTTPRequest request(String path, Object obj) throws SerializationException {
        return this.request(path, obj, null);
    }

    protected final HTTPRequest request(String path, Object obj, JavaType type) throws SerializationException {
        try {
            ObjectWriter bodyWriter = mapper.writer();
            if (type != null && (obj instanceof Set || obj instanceof List)) {
                bodyWriter = bodyWriter.forType(type);
            }
            String body = bodyWriter.writeValueAsString(obj);
            return this.request(path).body(body).header("Content-Type", "application/json;charset=UTF-8");
        }
        catch (IOException e) {
            throw new SerializationException();
        }
    }

    protected static final void assertSuccess(String path, HttpResponse response) throws ClientErrorException, ServerErrorException {
        switch (HttpStatusClass.get(response)) {
            case CLIENT_ERROR: {
                throw new ClientErrorException(String.format("Client error (status: %d, request path: %s).", WS.getStatus((HttpResponse)response), path));
            }
            case SERVER_ERROR: {
                throw new ServerErrorException(String.format("Server error (status: %d, request path: %s).", WS.getStatus((HttpResponse)response), path));
            }
        }
    }

    protected final JavaType getSetType(Class<?> clazz) {
        return mapper.getTypeFactory().constructCollectionType(Set.class, clazz);
    }

    protected String pathGenerator(String path, String ... replace) {
        String[] split = path.split("/");
        if (split.length < 1) {
            return path;
        }
        StringBuffer buffer = new StringBuffer();
        String[] parts = split;
        if (split[0].isEmpty()) {
            parts = Arrays.copyOfRange(split, 1, split.length);
        }
        int counter = 0;
        for (String part : parts) {
            buffer.append("/");
            if (part.matches(VAR_PATTERN) && replace.length - 1 >= counter) {
                buffer.append(replace[counter++]);
                continue;
            }
            buffer.append(part);
        }
        return buffer.toString();
    }

    protected void setPasswordMode(String password, String username) {
        this.password = password;
        this.username = username;
    }

    protected void setTokenMode(String token, String agent) {
        this.token = token;
        this.agent = agent;
    }
}

