/*
 * Decompiled with CFR 0.152.
 */
package de.cinovo.cloudconductor.api;

public enum ServiceState {
    STARTING,
    STARTED,
    IN_SERVICE,
    STOPPING,
    STOPPED,
    RESTARTING_STOPPING,
    RESTARTING_STARTING;

    public static ServiceState[] STARTED_STATES;
    public static ServiceState[] STOPPED_STATES;
    public static ServiceState[] INFLIGHT_STATES;
    public static ServiceState[] STABLE_STATES;
    public static ServiceState[] RESTARTING_STATES;

    public ServiceState next() {
        ServiceState current = ServiceState.valueOf(this.name());
        boolean inflight = false;
        for (ServiceState s : INFLIGHT_STATES) {
            if (!s.equals((Object)current)) continue;
            inflight = true;
        }
        if (inflight) {
            switch (current) {
                case RESTARTING_STARTING: {
                    return STARTED;
                }
                case RESTARTING_STOPPING: {
                    return RESTARTING_STARTING;
                }
                case STARTING: {
                    return STARTED;
                }
                case STOPPING: {
                    return STOPPED;
                }
            }
        }
        return current;
    }

    static {
        STARTED_STATES = new ServiceState[]{STARTED, IN_SERVICE};
        STOPPED_STATES = new ServiceState[]{STOPPING, STOPPED};
        INFLIGHT_STATES = new ServiceState[]{STARTING, STOPPING, RESTARTING_STOPPING, RESTARTING_STARTING};
        STABLE_STATES = new ServiceState[]{STARTED, IN_SERVICE, STOPPED};
        RESTARTING_STATES = new ServiceState[]{RESTARTING_STOPPING, RESTARTING_STARTING};
    }
}

