/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.scala.utils;

import de.christofreichardt.diagnosis.AbstractTracer;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005I4AAC\u0006\u0001)!)!\u0004\u0001C\u00017!9a\u0004\u0001b\u0001\n\u0003y\u0002BB\u001a\u0001A\u0003%\u0001\u0005C\u00045\u0001\t\u0007I\u0011B\u001b\t\ry\u0002\u0001\u0015!\u00037\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u0015y\u0004\u0001\"\u0001R\u0011\u0015y\u0004\u0001\"\u0001Y\u0011\u00159\u0007\u0001\"\u0001i\u0005EQ5o\u001c8Qe\u0016$H/\u001f)sS:$XM\u001d\u0006\u0003\u00195\tQ!\u001e;jYNT!AD\b\u0002\u000bM\u001c\u0017\r\\1\u000b\u0005A\t\u0012!E2ie&\u001cHo\u001c4sK&\u001c\u0007.\u0019:ei*\t!#\u0001\u0002eK\u000e\u00011C\u0001\u0001\u0016!\t1\u0002$D\u0001\u0018\u0015\u0005q\u0011BA\r\u0018\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\b\t\u0003;\u0001i\u0011aC\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001cX#\u0001\u0011\u0011\t\u00052\u0003&F\u0007\u0002E)\u00111\u0005J\u0001\u0005kRLGNC\u0001&\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0012#a\u0002%bg\"l\u0015\r\u001d\t\u0003SAr!A\u000b\u0018\u0011\u0005-:R\"\u0001\u0017\u000b\u00055\u001a\u0012A\u0002\u001fs_>$h(\u0003\u00020/\u00051\u0001K]3eK\u001aL!!\r\u001a\u0003\rM#(/\u001b8h\u0015\tys#A\u0006qe>\u0004XM\u001d;jKN\u0004\u0013!D<sSR,'OR1di>\u0014\u00180F\u00017!\t9D(D\u00019\u0015\tI$(\u0001\u0003kg>t'\"A\u001e\u0002\u000b)\fg/\u0019=\n\u0005uB$!\u0005&t_:<&/\u001b;fe\u001a\u000b7\r^8ss\u0006qqO]5uKJ4\u0015m\u0019;pef\u0004\u0013!\u00029sS:$HcA!E\u0019B\u0011aCQ\u0005\u0003\u0007^\u0011A!\u00168ji\")QI\u0002a\u0001\r\u0006\u0019q.\u001e;\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%#\u0013AA5p\u0013\tY\u0005J\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW\u000eC\u0003N\r\u0001\u0007a*\u0001\u0006kg>twJ\u00196fGR\u0004\"aN(\n\u0005AC$A\u0003&t_:|%M[3diR\u0019\u0011IU,\t\u000bM;\u0001\u0019\u0001+\u0002\t\u0019LG.\u001a\t\u0003\u000fVK!A\u0016%\u0003\t\u0019KG.\u001a\u0005\u0006\u001b\u001e\u0001\rA\u0014\u000b\u0004\u0003f\u0013\u0007\"\u0002.\t\u0001\u0004Y\u0016\u0001\u00029bi\"\u0004\"\u0001\u00181\u000e\u0003uS!a\u00150\u000b\u0005}#\u0013a\u00018j_&\u0011\u0011-\u0018\u0002\u0005!\u0006$\b\u000eC\u0003d\u0011\u0001\u0007A-\u0001\u0006kg>t7\u000b\u001e:vGR\u0004\"aN3\n\u0005\u0019D$!\u0004&t_:\u001cFO];diV\u0014X-A\u0003ue\u0006\u001cW\rF\u0002BSFDQA[\u0005A\u0002-\fa\u0001\u001e:bG\u0016\u0014\bC\u00017p\u001b\u0005i'B\u00018\u0010\u0003%!\u0017.Y4o_NL7/\u0003\u0002q[\nq\u0011IY:ue\u0006\u001cG\u000f\u0016:bG\u0016\u0014\b\"B2\n\u0001\u0004!\u0007")
public class JsonPrettyPrinter {
    private final HashMap<String, Object> properties = new HashMap();
    private final JsonWriterFactory writerFactory;

    public HashMap<String, Object> properties() {
        return this.properties;
    }

    private JsonWriterFactory writerFactory() {
        return this.writerFactory;
    }

    public void print(OutputStream out, JsonObject jsonObject) {
        try (JsonWriter writer = this.writerFactory().createWriter(out, StandardCharsets.UTF_8);){
            writer.writeObject(jsonObject);
        }
    }

    public void print(File file, JsonObject jsonObject) {
        FileOutputStream out = new FileOutputStream(file);
        try (JsonWriter writer = this.writerFactory().createWriter((OutputStream)out, StandardCharsets.UTF_8);){
            writer.writeObject(jsonObject);
        }
    }

    public void print(Path path, JsonStructure jsonStruct) {
        FileOutputStream out = new FileOutputStream(path.toFile());
        try (JsonWriter writer = this.writerFactory().createWriter((OutputStream)out, StandardCharsets.UTF_8);){
            writer.write(jsonStruct);
        }
    }

    public void trace(AbstractTracer tracer, JsonStructure jsonStruct) {
        byte[] byArray;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (JsonWriter writer = this.writerFactory().createWriter((OutputStream)out, StandardCharsets.UTF_8);){
            writer.write(jsonStruct);
            byArray = out.toByteArray();
        }
        byte[] bytes = byArray;
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        InputStreamReader streamReader = new InputStreamReader(in);
        try (BufferedReader bufferedReader = new BufferedReader(streamReader);){
            bufferedReader.lines().forEach(line -> tracer.out().printfIndentln(line, new Object[0]));
        }
        tracer.out().println();
    }

    public JsonPrettyPrinter() {
        this.properties().put("javax.json.stream.JsonGenerator.prettyPrinting", Boolean.TRUE);
        this.writerFactory = Json.createWriterFactory(this.properties());
    }
}

