/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.scala.shamir;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.scala.combinations.LazyBinomialCombinator;
import de.christofreichardt.scala.diagnosis.Tracing;
import de.christofreichardt.scala.shamir.Polynomial;
import de.christofreichardt.scala.shamir.SecretMerging;
import de.christofreichardt.scala.shamir.SecretMerging$;
import de.christofreichardt.scala.shamir.package$;
import de.christofreichardt.scala.utils.JsonPrettyPrinter;
import de.christofreichardt.scala.utils.RandomGenerator;
import java.io.Serializable;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonValue;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.SeqOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.BigInt;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\u0005eh\u0001B\u0016-\u0001UB\u0001\"\u0011\u0001\u0003\u0006\u0004%\tA\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u0007\"Aq\t\u0001BC\u0002\u0013\u0005!\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003D\u0011!I\u0005A!b\u0001\n\u0003Q\u0005\u0002\u0003.\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u0011m\u0003!Q1A\u0005\u0002qC\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006I!\u0018\u0005\u0006M\u0002!\ta\u001a\u0005\u0006M\u0002!\tA\u001c\u0005\u0006M\u0002!\t\u0001\u001d\u0005\u0006M\u0002!\t\u0001\u001e\u0005\u0006M\u0002!\ta\u001f\u0005\t\u0003\u001b\u0001!\u0019!C\u0001\u0005\"9\u0011q\u0002\u0001!\u0002\u0013\u0019\u0005\u0002CA\t\u0001\t\u0007I\u0011\u0001\"\t\u000f\u0005M\u0001\u0001)A\u0005\u0007\"I\u0011Q\u0003\u0001C\u0002\u0013\u0005\u0011q\u0003\u0005\t\u0003?\u0001\u0001\u0015!\u0003\u0002\u001a!I\u0011\u0011\u0005\u0001C\u0002\u0013\u0005\u00111\u0005\u0005\t\u0003c\u0001\u0001\u0015!\u0003\u0002&!I\u00111\u0007\u0001C\u0002\u0013\u0005\u0011q\u0003\u0005\t\u0003k\u0001\u0001\u0015!\u0003\u0002\u001a!I\u0011q\u0007\u0001C\u0002\u0013\u0005\u0011\u0011\b\u0005\t\u0003\u0003\u0002\u0001\u0015!\u0003\u0002<!I\u00111\t\u0001C\u0002\u0013\u0005\u0011Q\t\u0005\t\u0003\u001f\u0002\u0001\u0015!\u0003\u0002H!I\u0011\u0011\u000b\u0001C\u0002\u0013\u0005\u00111\u000b\u0005\t\u0003K\u0002\u0001\u0015!\u0003\u0002V!Q\u0011q\r\u0001\t\u0006\u0004%\t!!\u001b\t\u0015\u0005m\u0004\u0001#b\u0001\n\u0003\ti\bC\u0004\u0002\u0006\u0002!\t!a\u0006\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002\n\"9\u0011Q\u0012\u0001\u0005\u0006\u0005=\u0005bBAR\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003K\u0003A\u0011AA?\u0011\u001d\t9\u0007\u0001C\u0001\u0003OCq!!,\u0001\t\u0003\ty\u000bC\u0004\u0002B\u0002!\t!a1\t\u000f\u0005=\u0007\u0001\"\u0001\u0002R\"9\u0011q\u001a\u0001\u0005\u0002\u0005=\bbBA{\u0001\u0011\u0005\u0013q\u001f\u0002\u000e'\u0016\u001c'/\u001a;TQ\u0006\u0014\u0018N\\4\u000b\u00055r\u0013AB:iC6L'O\u0003\u00020a\u0005)1oY1mC*\u0011\u0011GM\u0001\u0012G\"\u0014\u0018n\u001d;pMJ,\u0017n\u00195be\u0012$(\"A\u001a\u0002\u0005\u0011,7\u0001A\n\u0004\u0001YZ\u0004CA\u001c:\u001b\u0005A$\"A\u0018\n\u0005iB$AB!osJ+g\r\u0005\u0002=\u007f5\tQH\u0003\u0002?]\u0005IA-[1h]>\u001c\u0018n]\u0005\u0003\u0001v\u0012q\u0001\u0016:bG&tw-\u0001\u0004tQ\u0006\u0014Xm]\u000b\u0002\u0007B\u0011q\u0007R\u0005\u0003\u000bb\u00121!\u00138u\u0003\u001d\u0019\b.\u0019:fg\u0002\n\u0011\u0002\u001e5sKNDw\u000e\u001c3\u0002\u0015QD'/Z:i_2$\u0007%A\u0006tK\u000e\u0014X\r\u001e\"zi\u0016\u001cX#A&\u0011\u00071#vK\u0004\u0002N%:\u0011a*U\u0007\u0002\u001f*\u0011\u0001\u000bN\u0001\u0007yI|w\u000e\u001e \n\u0003=J!a\u0015\u001d\u0002\u000fA\f7m[1hK&\u0011QK\u0016\u0002\u000b\u0013:$W\r_3e'\u0016\f(BA*9!\t9\u0004,\u0003\u0002Zq\t!!)\u001f;f\u00031\u0019Xm\u0019:fi\nKH/Z:!\u0003\u0019\u0011\u0018M\u001c3p[V\tQ\f\u0005\u0002_G6\tqL\u0003\u0002aC\u0006A1/Z2ve&$\u0018PC\u0001c\u0003\u0011Q\u0017M^1\n\u0005\u0011|&\u0001D*fGV\u0014XMU1oI>l\u0017a\u0002:b]\u0012|W\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b!T7\u000e\\7\u0011\u0005%\u0004Q\"\u0001\u0017\t\u000b\u0005K\u0001\u0019A\"\t\u000b\u001dK\u0001\u0019A\"\t\u000b%K\u0001\u0019A&\t\u000bmK\u0001\u0019A/\u0015\u0005!|\u0007\"B%\u000b\u0001\u0004YE\u0003\u00025reNDQ!Q\u0006A\u0002\rCQaR\u0006A\u0002\rCQ!S\u0006A\u0002-#B\u0001[;wo\")\u0011\t\u0004a\u0001\u0007\")q\t\u0004a\u0001\u0007\")\u0011\n\u0004a\u0001qB\u0019q'_,\n\u0005iD$!B!se\u0006LH\u0003\u00025}{zDQ!Q\u0007A\u0002\rCQaR\u0007A\u0002\rCaa`\u0007A\u0002\u0005\u0005\u0011\u0001\u00039bgN<xN\u001d3\u0011\t\u0005\r\u0011\u0011B\u0007\u0003\u0003\u000bQ1!a\u0002b\u0003\u0011a\u0017M\\4\n\t\u0005-\u0011Q\u0001\u0002\r\u0007\"\f'oU3rk\u0016t7-Z\u0001\u0002]\u0006\u0011a\u000eI\u0001\u0002W\u0006\u00111\u000eI\u0001\u0002gV\u0011\u0011\u0011\u0004\t\u0004\u0019\u0006m\u0011bAA\u000f-\n1!)[4J]R\f!a\u001d\u0011\u0002\u001fI\fg\u000eZ8n\u000f\u0016tWM]1u_J,\"!!\n\u0011\t\u0005\u001d\u0012QF\u0007\u0003\u0003SQ1!a\u000b/\u0003\u0015)H/\u001b7t\u0013\u0011\ty#!\u000b\u0003\u001fI\u000bg\u000eZ8n\u000f\u0016tWM]1u_J\f\u0001C]1oI>lw)\u001a8fe\u0006$xN\u001d\u0011\u0002\u000bA\u0014\u0018.\\3\u0002\rA\u0014\u0018.\\3!\u0003)\u0001x\u000e\\=o_6L\u0017\r\\\u000b\u0003\u0003w\u00012![A\u001f\u0013\r\ty\u0004\f\u0002\u000b!>d\u0017P\\8nS\u0006d\u0017a\u00039pYftw.\\5bY\u0002\n1b\u001d5be\u0016\u0004v.\u001b8ugV\u0011\u0011q\t\t\u0005\u0019R\u000bI\u0005E\u00048\u0003\u0017\nI\"!\u0007\n\u0007\u00055\u0003H\u0001\u0004UkBdWMM\u0001\rg\"\f'/\u001a)pS:$8\u000fI\u0001\u0003S\u0012,\"!!\u0016\u0011\t\u0005]\u0013q\f\b\u0005\u00033\nY\u0006\u0005\u0002Oq%\u0019\u0011Q\f\u001d\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t'a\u0019\u0003\rM#(/\u001b8h\u0015\r\ti\u0006O\u0001\u0004S\u0012\u0004\u0013!E:iCJ,\u0007k\\5oiN\f5OS:p]V\u0011\u00111\u000e\t\u0005\u0003[\n9(\u0004\u0002\u0002p)!\u0011\u0011OA:\u0003\u0011Q7o\u001c8\u000b\u0005\u0005U\u0014!\u00026bm\u0006D\u0018\u0002BA=\u0003_\u0012!BS:p]>\u0013'.Z2u\u0003!1XM]5gS\u0016$WCAA@!\r9\u0014\u0011Q\u0005\u0004\u0003\u0007C$a\u0002\"p_2,\u0017M\\\u0001\fG\"|wn]3Qe&lW-A\u000edQ>|7/Z\"b]>t\u0017nY1m\u0007>,gMZ5dS\u0016tGo]\u000b\u0003\u0003\u0017\u0003B\u0001\u0014+\u0002\u001a\u0005\u00012\r[8pg\u0016\u0004v\u000e\\=o_6L\u0017\r\u001c\u000b\u0005\u0003w\t\t\n\u0003\u0004\u0002\u0014\n\u0002\raQ\u0001\u0007I\u0016<'/Z3)\u0007\t\n9\n\u0005\u0003\u0002\u001a\u0006}UBAAN\u0015\r\ti\nO\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAQ\u00037\u0013q\u0001^1jYJ,7-A\u0007d_6\u0004X\u000f^3TQ\u0006\u0014Xm]\u0001\nm\u0016\u0014\u0018NZ=BY2$B!a\u001b\u0002*\"9\u00111V\u0013A\u0002\u0005\u001d\u0013A\u00019t\u0003M\u0019\b.\u0019:f!>Lg\u000e\u001e)beRLG/[8o)\u0011\t\t,a.\u0011\u000b1\u000b\u0019,a\u0012\n\u0007\u0005UfK\u0001\u0003MSN$\bbBA]M\u0001\u0007\u00111X\u0001\u0006g&TXm\u001d\t\u0005\u0019\u0006u6)C\u0002\u0002@Z\u0013\u0001\"\u0013;fe\u0006\u0014G.Z\u0001\u0010a\u0006\u0014H/\u001b;j_:\f5OS:p]R!\u0011QYAf!\u0011\ti'a2\n\t\u0005%\u0017q\u000e\u0002\n\u0015N|g.\u0011:sCfDq!!/(\u0001\u0004\ti\rE\u00028s\u000e\u000bQb]1wKB\u000b'\u000f^5uS>tGCBAj\u00033\fY\u000eE\u00028\u0003+L1!a69\u0005\u0011)f.\u001b;\t\u000f\u0005e\u0006\u00061\u0001\u0002<\"9\u0011Q\u001c\u0015A\u0002\u0005}\u0017\u0001\u00029bi\"\u0004B!!9\u0002l6\u0011\u00111\u001d\u0006\u0005\u0003K\f9/\u0001\u0003gS2,'bAAuC\u0006\u0019a.[8\n\t\u00055\u00181\u001d\u0002\u0005!\u0006$\b\u000e\u0006\u0004\u0002T\u0006E\u00181\u001f\u0005\b\u0003sK\u0003\u0019AAg\u0011\u001d\ti.\u000ba\u0001\u0003?\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003+\u0002")
public class SecretSharing
implements Tracing {
    private JsonObject sharePointsAsJson;
    private boolean verified;
    private final int shares;
    private final int threshold;
    private final IndexedSeq<Object> secretBytes;
    private final SecureRandom random;
    private final int n;
    private final int k;
    private final BigInt s;
    private final RandomGenerator randomGenerator;
    private final BigInt prime;
    private final Polynomial polynomial;
    private final IndexedSeq<Tuple2<BigInt, BigInt>> sharePoints;
    private final String id;
    private volatile byte bitmap$0;

    @Override
    public <T> T withTracer(String resultType, Object callee, String method, Function0<T> block) {
        return (T)Tracing.withTracer$(this, resultType, callee, method, block);
    }

    @Override
    public AbstractTracer getCurrentTracer() {
        return Tracing.getCurrentTracer$(this);
    }

    public int shares() {
        return this.shares;
    }

    public int threshold() {
        return this.threshold;
    }

    public IndexedSeq<Object> secretBytes() {
        return this.secretBytes;
    }

    public SecureRandom random() {
        return this.random;
    }

    public int n() {
        return this.n;
    }

    public int k() {
        return this.k;
    }

    public BigInt s() {
        return this.s;
    }

    public RandomGenerator randomGenerator() {
        return this.randomGenerator;
    }

    public BigInt prime() {
        return this.prime;
    }

    public Polynomial polynomial() {
        return this.polynomial;
    }

    public IndexedSeq<Tuple2<BigInt, BigInt>> sharePoints() {
        return this.sharePoints;
    }

    public String id() {
        return this.id;
    }

    private JsonObject sharePointsAsJson$lzycompute() {
        SecretSharing secretSharing = this;
        synchronized (secretSharing) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.sharePointsAsJson = this.sharePointsAsJson(this.sharePoints());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.sharePointsAsJson;
    }

    public JsonObject sharePointsAsJson() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.sharePointsAsJson$lzycompute() : this.sharePointsAsJson;
    }

    private boolean verified$lzycompute() {
        SecretSharing secretSharing = this;
        synchronized (secretSharing) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.verified = this.verifyAll();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.verified;
    }

    public boolean verified() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.verified$lzycompute() : this.verified;
    }

    public BigInt choosePrime() {
        int BIT_OFFSET = 1;
        int bits = this.s().bitLength() + BIT_OFFSET;
        return scala.package$.MODULE$.BigInt().apply(bits, package$.MODULE$.CERTAINTY(), Random$.MODULE$.javaRandomToRandom((Random)this.random()));
    }

    public IndexedSeq<BigInt> chooseCanonicalCoefficients() {
        int bits = this.s().bitLength() * 2;
        return this.randomGenerator().bigIntStream(bits, this.prime()).take(this.k() - 1).toIndexedSeq();
    }

    public final Polynomial choosePolynomial(int degree) {
        Polynomial candidate;
        while ((candidate = new Polynomial((IndexedSeq<BigInt>)((IndexedSeq)this.chooseCanonicalCoefficients().$colon$plus((Object)this.s())), this.prime())).degree() != degree) {
        }
        return candidate;
    }

    public IndexedSeq<Tuple2<BigInt, BigInt>> computeShares() {
        int bits = this.s().bitLength() * 2;
        return ((LazyList)this.randomGenerator().bigIntStream(bits, this.prime()).filterNot((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)SecretSharing.$anonfun$computeShares$1(x))).distinct()).take(this.shares()).map((Function1 & Serializable)x -> new Tuple2(x, (Object)this.polynomial().evaluateAt((BigInt)x))).toIndexedSeq();
    }

    public boolean verifyAll() {
        LazyBinomialCombinator combinator = new LazyBinomialCombinator(this.n(), this.k());
        return combinator.produceAll().map((Function1 & Serializable)combination -> {
            IndexedSeq indices = combination;
            IndexedSeq selectedPoints = (IndexedSeq)indices.map((Function1 & Serializable)index -> SecretSharing.$anonfun$verifyAll$2(this, BoxesRunTime.unboxToInt((Object)index)));
            SecretMerging merger = SecretMerging$.MODULE$.apply((IndexedSeq<Tuple2<BigInt, BigInt>>)selectedPoints, this.prime());
            return merger.secretBytes();
        }).forall((Function1 & Serializable)bytes -> BoxesRunTime.boxToBoolean((boolean)SecretSharing.$anonfun$verifyAll$3(this, bytes)));
    }

    public JsonObject sharePointsAsJson(IndexedSeq<Tuple2<BigInt, BigInt>> ps2) {
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        ps2.foreach((Function1 & Serializable)ps -> arrayBuilder.add(Json.createObjectBuilder().add("SharePoint", Json.createObjectBuilder().add("x", ((BigInt)ps._1()).bigInteger()).add("y", ((BigInt)ps._2()).bigInteger()))));
        return Json.createObjectBuilder().add("PartitionId", this.id()).add("Prime", this.prime().bigInteger()).add("Threshold", this.threshold()).add("SharePoints", (JsonValue)arrayBuilder.build()).build();
    }

    public List<IndexedSeq<Tuple2<BigInt, BigInt>>> sharePointPartition(Iterable<Object> sizes) {
        Predef$.MODULE$.require(BoxesRunTime.unboxToInt((Object)sizes.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) == this.sharePoints().length(), (Function0 & Serializable)() -> "The sum of the shares of each slice doesn't match the number of overall shares.");
        Predef$.MODULE$.require(sizes.forall((Function1)(JFunction1.mcZI.sp & Serializable)s -> s <= this.k()), (Function0 & Serializable)() -> "A particular slice must not exceed the threshold.");
        return this.partition$1(sizes, this.sharePoints(), (List)scala.package$.MODULE$.List().apply((Seq)Nil$.MODULE$));
    }

    public JsonArray partitionAsJson(int[] sizes) {
        List<IndexedSeq<Tuple2<BigInt, BigInt>>> partition = this.sharePointPartition((Iterable<Object>)Predef$.MODULE$.wrapIntArray(sizes));
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        partition.map((Function1 & Serializable)slice -> this.sharePointsAsJson((IndexedSeq<Tuple2<BigInt, BigInt>>)slice)).foreach((Function1 & Serializable)slice -> arrayBuilder.add((JsonValue)slice));
        return arrayBuilder.build();
    }

    public void savePartition(Iterable<Object> sizes, Path path) {
        Predef$.MODULE$.require(path.getParent().toFile().exists() && path.getParent().toFile().isDirectory());
        JsonPrettyPrinter prettyPrinter = new JsonPrettyPrinter();
        prettyPrinter.print(path.getParent().resolve(new StringBuilder(5).append(((Object)path.getFileName()).toString()).append(".json").toString()).toFile(), this.sharePointsAsJson());
        List<IndexedSeq<Tuple2<BigInt, BigInt>>> partition = this.sharePointPartition(sizes);
        ((List)partition.map((Function1 & Serializable)part -> this.sharePointsAsJson((IndexedSeq<Tuple2<BigInt, BigInt>>)part)).zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            SecretSharing.$anonfun$savePartition$2(prettyPrinter, path, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void savePartition(int[] sizes, Path path) {
        this.savePartition((Iterable<Object>)Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.reverse$extension(Predef$.MODULE$.intArrayOps(sizes))).toIterable(), path);
    }

    public String toString() {
        return String.format("SecretSharing[shares=%d, threshold=%d, s=%s, polynomial=%s, sharePoints=(%s)]", Predef$.MODULE$.int2Integer(this.shares()), Predef$.MODULE$.int2Integer(this.threshold()), this.s(), this.polynomial(), this.sharePoints().mkString(","));
    }

    public static final /* synthetic */ boolean $anonfun$computeShares$1(BigInt x) {
        BigInt bigInt = x;
        BigInt bigInt2 = scala.package$.MODULE$.BigInt().apply(0);
        return !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null);
    }

    public static final /* synthetic */ Tuple2 $anonfun$verifyAll$2(SecretSharing $this, int index) {
        return (Tuple2)$this.sharePoints().apply(index);
    }

    public static final /* synthetic */ boolean $anonfun$verifyAll$3(SecretSharing $this, IndexedSeq bytes) {
        IndexedSeq indexedSeq = bytes;
        IndexedSeq<Object> indexedSeq2 = $this.secretBytes();
        return !(indexedSeq != null ? !indexedSeq.equals(indexedSeq2) : indexedSeq2 != null);
    }

    private final List partition$1(Iterable sizes, IndexedSeq remainingPoints, List partitions) {
        while (!sizes.isEmpty()) {
            IndexedSeq indexedSeq = (IndexedSeq)remainingPoints.take(BoxesRunTime.unboxToInt((Object)sizes.head()));
            partitions = partitions.$colon$colon((Object)indexedSeq);
            remainingPoints = (IndexedSeq)remainingPoints.drop(BoxesRunTime.unboxToInt((Object)sizes.head()));
            sizes = (Iterable)sizes.tail();
        }
        return partitions;
    }

    public static final /* synthetic */ void $anonfun$savePartition$2(JsonPrettyPrinter prettyPrinter$1, Path path$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        JsonObject jsonObject = (JsonObject)tuple2._1();
        int i = tuple2._2$mcI$sp();
        prettyPrinter$1.print(path$1.getParent().resolve(new StringBuilder(6).append(((Object)path$1.getFileName()).toString()).append("-").append(i).append(".json").toString()).toFile(), jsonObject);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public SecretSharing(int shares, int threshold, IndexedSeq<Object> secretBytes, SecureRandom random) {
        this.shares = shares;
        this.threshold = threshold;
        this.secretBytes = secretBytes;
        this.random = random;
        Tracing.$init$(this);
        this.n = shares;
        this.k = threshold;
        Predef$.MODULE$.require(this.n() >= 2 && this.k() >= 2, (Function0 & Serializable)() -> "We need at least two shares, otherwise we wouldn't need shares at all.");
        Predef$.MODULE$.require(this.k() <= this.n(), (Function0 & Serializable)() -> "The threshold must be less than or equal to the number of shares.");
        Predef$.MODULE$.require(secretBytes.length() >= 2, (Function0 & Serializable)() -> "Too few secret bytes.");
        this.s = package$.MODULE$.bytes2BigInt(secretBytes);
        this.randomGenerator = new RandomGenerator(random);
        this.prime = this.choosePrime();
        Predef$.MODULE$.require(scala.package$.MODULE$.BigInt().apply(this.n()).$times(scala.package$.MODULE$.BigInt().apply(this.n())).$less$eq((Object)this.prime()), (Function0 & Serializable)() -> "Too much shares for given secret.");
        Predef$.MODULE$.require(this.s().$less((Object)this.prime()), (Function0 & Serializable)() -> "The encoded secret must be strictly smaller than the prime modulus.");
        this.polynomial = this.choosePolynomial(this.k() - 1);
        this.sharePoints = this.computeShares();
        Predef$.MODULE$.require(this.polynomial().degree() == this.k() - 1);
        Predef$.MODULE$.require(((SeqOps)((SeqOps)this.sharePoints().map((Function1 & Serializable)point -> (BigInt)point._1())).distinct()).length() == this.n(), (Function0 & Serializable)() -> String.format("%d distinct sharepoints are needed: %s", BoxesRunTime.boxToInteger((int)this.n()), this.sharePoints()));
        this.id = UUID.randomUUID().toString();
    }

    public SecretSharing(IndexedSeq<Object> secretBytes) {
        this(6, 3, secretBytes, new SecureRandom());
    }

    public SecretSharing(int shares, int threshold, IndexedSeq<Object> secretBytes) {
        this(shares, threshold, secretBytes, new SecureRandom());
    }

    public SecretSharing(int shares, int threshold, byte[] secretBytes) {
        this(shares, threshold, (IndexedSeq<Object>)ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.byteArrayOps(secretBytes)), new SecureRandom());
    }

    public SecretSharing(int shares, int threshold, CharSequence password) {
        this(shares, threshold, package$.MODULE$.charSequenceToByteArray(password));
    }
}

