/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.scala.shamir;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.scala.diagnosis.Tracing;
import de.christofreichardt.scala.shamir.NewtonInterpolation;
import de.christofreichardt.scala.shamir.SecretMerging$;
import de.christofreichardt.scala.shamir.package$;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import javax.json.JsonArray;
import scala.Function0;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.IndexedSeq;
import scala.math.BigInt;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005%b\u0001\u0002\f\u0018\u0001\u0001B\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!\f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005]!A\u0011\t\u0001BC\u0002\u0013\u0005!\t\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003>\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u001dQ\u0005A1A\u0005\u0002-Caa\u0014\u0001!\u0002\u0013a\u0005b\u0002)\u0001\u0005\u0004%\tA\u0011\u0005\u0007#\u0002\u0001\u000b\u0011B\u001f\t\u000fI\u0003!\u0019!C\u0001'\"1\u0001\f\u0001Q\u0001\nQCQ!\u0017\u0001\u0005\u0002i;Q!Y\f\t\u0002\t4QAF\f\t\u0002\rDQ\u0001\u0012\b\u0005\u0002\u0011DQ!\u001a\b\u0005\u0002\u0019DQ!\u001a\b\u0005\u0002%DQ!\u001a\b\u0005\u0002YDQ\u0001 \b\u0005\nuDa!\u001a\b\u0005\u0002\u0005]\u0001BB3\u000f\t\u0003\tiBA\u0007TK\u000e\u0014X\r^'fe\u001eLgn\u001a\u0006\u00031e\taa\u001d5b[&\u0014(B\u0001\u000e\u001c\u0003\u0015\u00198-\u00197b\u0015\taR$A\tdQJL7\u000f^8ge\u0016L7\r[1sIRT\u0011AH\u0001\u0003I\u0016\u001c\u0001aE\u0002\u0001C\u0019\u0002\"A\t\u0013\u000e\u0003\rR\u0011AG\u0005\u0003K\r\u0012a!\u00118z%\u00164\u0007CA\u0014+\u001b\u0005A#BA\u0015\u001a\u0003%!\u0017.Y4o_NL7/\u0003\u0002,Q\t9AK]1dS:<\u0017aC:iCJ,\u0007k\\5oiN,\u0012A\f\t\u0004_]RdB\u0001\u00196\u001d\t\tD'D\u00013\u0015\t\u0019t$\u0001\u0004=e>|GOP\u0005\u00025%\u0011agI\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0014H\u0001\u0006J]\u0012,\u00070\u001a3TKFT!AN\u0012\u0011\t\tZT(P\u0005\u0003y\r\u0012a\u0001V;qY\u0016\u0014\u0004CA\u0018?\u0013\ty\u0014H\u0001\u0004CS\u001eLe\u000e^\u0001\rg\"\f'/\u001a)pS:$8\u000fI\u0001\u0006aJLW.Z\u000b\u0002{\u00051\u0001O]5nK\u0002\na\u0001P5oSRtDc\u0001$I\u0013B\u0011q\tA\u0007\u0002/!)A&\u0002a\u0001]!)\u0011)\u0002a\u0001{\u0005i\u0011N\u001c;feB|G.\u0019;j_:,\u0012\u0001\u0014\t\u0003\u000f6K!AT\f\u0003'9+w\u000f^8o\u0013:$XM\u001d9pY\u0006$\u0018n\u001c8\u0002\u001d%tG/\u001a:q_2\fG/[8oA\u0005\t1/\u0001\u0002tA\u0005Y1/Z2sKR\u0014\u0015\u0010^3t+\u0005!\u0006cA\u00188+B\u0011!EV\u0005\u0003/\u000e\u0012AAQ=uK\u0006a1/Z2sKR\u0014\u0015\u0010^3tA\u0005A\u0001/Y:to>\u0014H-F\u0001\\!\r\u0011CLX\u0005\u0003;\u000e\u0012Q!\u0011:sCf\u0004\"AI0\n\u0005\u0001\u001c#\u0001B\"iCJ\fQbU3de\u0016$X*\u001a:hS:<\u0007CA$\u000f'\tq\u0011\u0005F\u0001c\u0003\u0015\t\u0007\u000f\u001d7z)\r1u\r\u001b\u0005\u0006YA\u0001\rA\f\u0005\u0006\u0003B\u0001\r!\u0010\u000b\u0003\r*DQa[\tA\u00021\fA\u0001]1uQB\u0011Q\u000e^\u0007\u0002]*\u0011q\u000e]\u0001\u0005M&dWM\u0003\u0002re\u0006\u0019a.[8\u000b\u0003M\fAA[1wC&\u0011QO\u001c\u0002\u0005!\u0006$\b\u000e\u0006\u0002Go\")\u0001P\u0005a\u0001s\u0006)\u0001/\u0019;igB\u0019qF\u001f7\n\u0005mL$\u0001C%uKJ\f'\r\\3\u0002\u001bA\u0014xnY3tgNc\u0017nY3t)\t1e\u0010\u0003\u0004\u0000'\u0001\u0007\u0011\u0011A\u0001\fUN|gn\u00142kK\u000e$8\u000fE\u00030\u0003\u0007\t9!C\u0002\u0002\u0006e\u00121aU3r!\u0011\tI!a\u0005\u000e\u0005\u0005-!\u0002BA\u0007\u0003\u001f\tAA[:p]*\u0011\u0011\u0011C\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0003+\tYA\u0001\u0006Kg>twJ\u00196fGR$2ARA\r\u0011\u0019AH\u00031\u0001\u0002\u001cA\u0019!\u0005\u00187\u0015\u0007\u0019\u000by\u0002C\u0004\u0002\"U\u0001\r!a\t\u0002\rMd\u0017nY3t!\u0011\tI!!\n\n\t\u0005\u001d\u00121\u0002\u0002\n\u0015N|g.\u0011:sCf\u0004")
public class SecretMerging
implements Tracing {
    private final IndexedSeq<Tuple2<BigInt, BigInt>> sharePoints;
    private final BigInt prime;
    private final NewtonInterpolation interpolation;
    private final BigInt s;
    private final IndexedSeq<Object> secretBytes;

    public static SecretMerging apply(JsonArray slices) {
        return SecretMerging$.MODULE$.apply(slices);
    }

    public static SecretMerging apply(Path[] paths) {
        return SecretMerging$.MODULE$.apply(paths);
    }

    public static SecretMerging apply(Iterable<Path> paths) {
        return SecretMerging$.MODULE$.apply(paths);
    }

    public static SecretMerging apply(Path path) {
        return SecretMerging$.MODULE$.apply(path);
    }

    public static SecretMerging apply(IndexedSeq<Tuple2<BigInt, BigInt>> sharePoints, BigInt prime) {
        return SecretMerging$.MODULE$.apply(sharePoints, prime);
    }

    @Override
    public <T> T withTracer(String resultType, Object callee, String method, Function0<T> block) {
        return (T)Tracing.withTracer$(this, resultType, callee, method, block);
    }

    @Override
    public AbstractTracer getCurrentTracer() {
        return Tracing.getCurrentTracer$(this);
    }

    public IndexedSeq<Tuple2<BigInt, BigInt>> sharePoints() {
        return this.sharePoints;
    }

    public BigInt prime() {
        return this.prime;
    }

    public NewtonInterpolation interpolation() {
        return this.interpolation;
    }

    public BigInt s() {
        return this.s;
    }

    public IndexedSeq<Object> secretBytes() {
        return this.secretBytes;
    }

    public char[] password() {
        ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])this.secretBytes().toArray((ClassTag)ClassTag$.MODULE$.Byte()));
        CharBuffer charBuffer = StandardCharsets.UTF_8.newDecoder().decode(byteBuffer);
        return Arrays.copyOf(charBuffer.array(), charBuffer.limit());
    }

    public SecretMerging(IndexedSeq<Tuple2<BigInt, BigInt>> sharePoints, BigInt prime) {
        this.sharePoints = sharePoints;
        this.prime = prime;
        Tracing.$init$(this);
        this.interpolation = new NewtonInterpolation(sharePoints, prime);
        this.s = this.interpolation().newtonPolynomial().evaluateAt(scala.package$.MODULE$.BigInt().apply(0));
        this.secretBytes = package$.MODULE$.bigIntToBytes(this.s());
    }
}

