/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.scala.shamir;

import de.christofreichardt.scala.shamir.SecretMerging;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.file.Path;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class SecretMerging$ {
    public static final SecretMerging$ MODULE$ = new SecretMerging$();

    public SecretMerging apply(IndexedSeq<Tuple2<BigInt, BigInt>> sharePoints, BigInt prime) {
        return new SecretMerging(sharePoints, prime);
    }

    public SecretMerging apply(Path path) {
        JsonObject jsonObject;
        try (FileInputStream fileIn = new FileInputStream(path.toFile());){
            jsonObject = Json.createReader((InputStream)fileIn).readObject();
        }
        JsonObject jsonObject2 = jsonObject;
        BigInteger prime = jsonObject2.getJsonNumber("Prime").bigIntegerValue();
        int threshold = jsonObject2.getInt("Threshold");
        JsonArray sharePointsAsJson = jsonObject2.getJsonArray("SharePoints");
        IndexedSeq ps = CollectionConverters$.MODULE$.IteratorHasAsScala(sharePointsAsJson.iterator()).asScala().map((Function1 & Serializable)sp2 -> sp2.asJsonObject().getJsonObject("SharePoint")).map((Function1 & Serializable)sp2 -> new Tuple2((Object)package$.MODULE$.BigInt().apply(sp2.getJsonNumber("x").bigIntegerValue()), (Object)package$.MODULE$.BigInt().apply(sp2.getJsonNumber("y").bigIntegerValue()))).toIndexedSeq();
        Predef$.MODULE$.require(ps.length() >= threshold);
        return new SecretMerging((IndexedSeq<Tuple2<BigInt, BigInt>>)((IndexedSeq)ps.take(threshold)), BigInt$.MODULE$.javaBigInteger2bigInt(prime));
    }

    public SecretMerging apply(Iterable<Path> paths) {
        IndexedSeq jsonObjects = ((IterableOnceOps)paths.map((Function1 & Serializable)path -> {
            JsonObject jsonObject;
            try (FileInputStream fileIn = new FileInputStream(path.toFile());){
                jsonObject = Json.createReader((InputStream)new FileInputStream(path.toFile())).readObject();
            }
            return jsonObject;
        })).toIndexedSeq();
        return this.processSlices((Seq<JsonObject>)jsonObjects);
    }

    private SecretMerging processSlices(Seq<JsonObject> jsonObjects) {
        Predef$.MODULE$.require(jsonObjects.nonEmpty(), (Function0 & Serializable)() -> "Empty Sequence.");
        Predef$.MODULE$.require(jsonObjects.forall((Function1 & Serializable)jsonObject -> BoxesRunTime.boxToBoolean((boolean)jsonObject.containsKey((Object)"PartitionId"))), (Function0 & Serializable)() -> "No PartitionId found.");
        Seq ids = (Seq)jsonObjects.map((Function1 & Serializable)jsonObject -> jsonObject.getString("PartitionId"));
        Predef$.MODULE$.require(ids.forall((Function1 & Serializable)id -> BoxesRunTime.boxToBoolean((boolean)SecretMerging$.$anonfun$processSlices$5(ids, id))), (Function0 & Serializable)() -> "Inconsistent PartitionIds.");
        Tuple2 tuple2 = (Tuple2)jsonObjects.view().map((Function1 & Serializable)jsonObject -> new Tuple2((Object)package$.MODULE$.BigInt().apply(jsonObject.getJsonNumber("Prime").bigIntegerValue()), (Object)BoxesRunTime.boxToInteger((int)jsonObject.getInt("Threshold")))).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        BigInt prime = (BigInt)tuple2._1();
        int threshold = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)prime, (Object)BoxesRunTime.boxToInteger((int)threshold));
        Tuple2 tuple23 = tuple22;
        BigInt prime2 = (BigInt)tuple23._1();
        int threshold2 = tuple23._2$mcI$sp();
        IndexedSeq ps = ((IterableOnceOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)jsonObjects.map((Function1 & Serializable)jsonObject -> jsonObject.getJsonArray("SharePoints"))).flatMap((Function1 & Serializable)jsonArray -> CollectionConverters$.MODULE$.IteratorHasAsScala(jsonArray.iterator()).asScala())).map((Function1 & Serializable)jsonValue -> jsonValue.asJsonObject())).map((Function1 & Serializable)jsonObject -> jsonObject.getJsonObject("SharePoint"))).map((Function1 & Serializable)sp2 -> new Tuple2((Object)package$.MODULE$.BigInt().apply(sp2.getJsonNumber("x").bigIntegerValue()), (Object)package$.MODULE$.BigInt().apply(sp2.getJsonNumber("y").bigIntegerValue())))).toIndexedSeq();
        Predef$.MODULE$.require(ps.length() >= threshold2, (Function0 & Serializable)() -> "Too few sharepoints.");
        return new SecretMerging((IndexedSeq<Tuple2<BigInt, BigInt>>)((IndexedSeq)ps.take(threshold2)), prime2);
    }

    public SecretMerging apply(Path[] paths) {
        return this.apply((Iterable<Path>)Predef$.MODULE$.wrapRefArray((Object[])paths).toIterable());
    }

    public SecretMerging apply(JsonArray slices) {
        Iterator iter = CollectionConverters$.MODULE$.IteratorHasAsScala(slices.iterator()).asScala();
        IndexedSeq jsonObjects = iter.map((Function1 & Serializable)jsonValue -> jsonValue.asJsonObject()).toIndexedSeq();
        return this.processSlices((Seq<JsonObject>)jsonObjects);
    }

    public static final /* synthetic */ boolean $anonfun$processSlices$5(Seq ids$1, String id) {
        String string = id;
        Object object = ids$1.head();
        return !(string != null ? !string.equals(object) : object != null);
    }

    private SecretMerging$() {
    }
}

