/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.scala.shamir;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.TracerFactory;
import de.christofreichardt.scala.diagnosis.Tracing;
import de.christofreichardt.scala.shamir.package$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.BigInt;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005a4A\u0001F\u000b\u0001=!A!\u0006\u0001BC\u0002\u0013\u00051\u0006\u0003\u00050\u0001\t\u0005\t\u0015!\u0003-\u0011!\u0001\u0004A!b\u0001\n\u0003\t\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u0011\t\u0003!Q1A\u0005\u0002EB\u0001b\u0011\u0001\u0003\u0002\u0003\u0006IA\r\u0005\t\t\u0002\u0011)\u0019!C\u0001\u000b\"Aa\t\u0001B\u0001B\u0003%a\bC\u0003H\u0001\u0011\u0005\u0001\nC\u0004P\u0001\t\u0007I\u0011A\u0016\t\rA\u0003\u0001\u0015!\u0003-\u0011\u001d\t\u0006A1A\u0005\u0002ICaA\u0016\u0001!\u0002\u0013\u0019\u0006bB,\u0001\u0005\u0004%\tA\u0015\u0005\u00071\u0002\u0001\u000b\u0011B*\t\u000be\u0003A\u0011\u0001.\t\u000b\r\u0004A\u0011\u00013\t\u000b\u001d\u0004A\u0011\t5\t\u000bE\u0004A\u0011\t:\u0003!9+w\u000f^8o!>d\u0017P\\8nS\u0006d'B\u0001\f\u0018\u0003\u0019\u0019\b.Y7je*\u0011\u0001$G\u0001\u0006g\u000e\fG.\u0019\u0006\u00035m\t\u0011c\u00195sSN$xN\u001a:fS\u000eD\u0017M\u001d3u\u0015\u0005a\u0012A\u00013f\u0007\u0001\u00192\u0001A\u0010%!\t\u0001#%D\u0001\"\u0015\u0005A\u0012BA\u0012\"\u0005\u0019\te.\u001f*fMB\u0011Q\u0005K\u0007\u0002M)\u0011qeF\u0001\nI&\fwM\\8tSNL!!\u000b\u0014\u0003\u000fQ\u0013\u0018mY5oO\u00061A-Z4sK\u0016,\u0012\u0001\f\t\u0003A5J!AL\u0011\u0003\u0007%sG/A\u0004eK\u001e\u0014X-\u001a\u0011\u0002\u000b\t\f7/[:\u0016\u0003I\u00022aM\u001e?\u001d\t!\u0014H\u0004\u00026q5\taG\u0003\u00028;\u00051AH]8pizJ\u0011\u0001G\u0005\u0003u\u0005\nq\u0001]1dW\u0006<W-\u0003\u0002={\tQ\u0011J\u001c3fq\u0016$7+Z9\u000b\u0005i\n\u0003CA\u001a@\u0013\t\u0001UH\u0001\u0004CS\u001eLe\u000e^\u0001\u0007E\u0006\u001c\u0018n\u001d\u0011\u0002\u0019\r|WM\u001a4jG&,g\u000e^:\u0002\u001b\r|WM\u001a4jG&,g\u000e^:!\u0003\u0015\u0001(/[7f+\u0005q\u0014A\u00029sS6,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0006\u0013.cUJ\u0014\t\u0003\u0015\u0002i\u0011!\u0006\u0005\u0006U%\u0001\r\u0001\f\u0005\u0006a%\u0001\rA\r\u0005\u0006\u0005&\u0001\rA\r\u0005\u0006\t&\u0001\rAP\u0001\u0002]\u0006\u0011a\u000eI\u0001\u0002GV\t1\u000bE\u00024)zJ!!V\u001f\u0003\u0007M+\u0017/\u0001\u0002dA\u0005\u0011\u0001\u0010_\u0001\u0004qb\u0004\u0013!\u00059bSJ<\u0018n]3ES\u001a4WM]3oiR\u00111L\u0018\t\u0003AqK!!X\u0011\u0003\u000f\t{w\u000e\\3b]\")q\f\u0005a\u0001A\u00061a/\u00197vKN\u00042aM1?\u0013\t\u0011WH\u0001\u0003MSN$\u0018AC3wC2,\u0018\r^3BiR\u0011a(\u001a\u0005\u0006MF\u0001\rAP\u0001\u0002q\u0006AAo\\*ue&tw\rF\u0001j!\tQgN\u0004\u0002lYB\u0011Q'I\u0005\u0003[\u0006\na\u0001\u0015:fI\u00164\u0017BA8q\u0005\u0019\u0019FO]5oO*\u0011Q.I\u0001\u0011O\u0016$8)\u001e:sK:$HK]1dKJ$\u0012a\u001d\t\u0003iZl\u0011!\u001e\u0006\u0003OeI!a^;\u0003\u001d\u0005\u00137\u000f\u001e:bGR$&/Y2fe\u0002")
public class NewtonPolynomial
implements Tracing {
    private final int degree;
    private final IndexedSeq<BigInt> basis;
    private final IndexedSeq<BigInt> coefficients;
    private final BigInt prime;
    private final int n;
    private final Seq<BigInt> c;
    private final Seq<BigInt> xx;

    @Override
    public <T> T withTracer(String resultType, Object callee, String method, Function0<T> block) {
        return (T)Tracing.withTracer$(this, resultType, callee, method, block);
    }

    public int degree() {
        return this.degree;
    }

    public IndexedSeq<BigInt> basis() {
        return this.basis;
    }

    public IndexedSeq<BigInt> coefficients() {
        return this.coefficients;
    }

    public BigInt prime() {
        return this.prime;
    }

    public int n() {
        return this.n;
    }

    public Seq<BigInt> c() {
        return this.c;
    }

    public Seq<BigInt> xx() {
        return this.xx;
    }

    public boolean pairwiseDifferent(List<BigInt> values) {
        boolean bl;
        SeqOps seqOps;
        List<BigInt> list = values;
        if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.List().unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
            bl = true;
        } else if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            BigInt head = (BigInt)colon2.head();
            List tail = colon2.next$access$1();
            bl = tail.contains((Object)head) ? false : this.pairwiseDifferent((List<BigInt>)tail);
        } else {
            throw new MatchError(list);
        }
        return bl;
    }

    public BigInt evaluateAt(BigInt x) {
        AbstractTracer tracer = this.getCurrentTracer();
        return (BigInt)this.withTracer("BigInt", this, "evaluateAt(x: BigInt)", (Function0 & Serializable)() -> {
            tracer.out().printfIndentln("x = %s", new Object[]{x});
            return this.evaluate$1(0, tracer, x);
        });
    }

    public String toString() {
        return String.format("NewtonPolynomial[degree=%d, c=(%s), x=(%s), prime=%s]", Predef$.MODULE$.int2Integer(this.n()), this.c().mkString(","), this.xx().mkString(","), this.prime());
    }

    @Override
    public AbstractTracer getCurrentTracer() {
        return TracerFactory.getInstance().getDefaultTracer();
    }

    private final BigInt evaluate$1(int m, AbstractTracer tracer$1, BigInt x$1) {
        tracer$1.out().printfIndentln("m = %d", new Object[]{Predef$.MODULE$.int2Integer(m)});
        return m == this.n() ? (BigInt)this.c().apply(this.n()) : this.evaluate$1(m + 1, tracer$1, x$1).$times(x$1.$minus((BigInt)this.xx().apply(m))).$plus((BigInt)this.c().apply(m)).mod(this.prime());
    }

    public NewtonPolynomial(int degree, IndexedSeq<BigInt> basis, IndexedSeq<BigInt> coefficients, BigInt prime) {
        this.degree = degree;
        this.basis = basis;
        this.coefficients = coefficients;
        this.prime = prime;
        Tracing.$init$(this);
        Predef$.MODULE$.require(prime.isProbablePrime(package$.MODULE$.CERTAINTY()));
        this.n = degree;
        Predef$.MODULE$.require(basis.length() == this.n());
        Predef$.MODULE$.require(coefficients.length() == this.n() + 1);
        this.c = (Seq)coefficients.map((Function1 & Serializable)b -> b.mod(this.prime()));
        this.xx = (Seq)basis.map((Function1 & Serializable)b -> b.mod(this.prime()));
        Predef$.MODULE$.require(this.pairwiseDifferent((List<BigInt>)this.xx().toList()), (Function0 & Serializable)() -> "Basis values must be pairwise different.");
    }
}

