/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.scala.shamir;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.TracerFactory;
import de.christofreichardt.scala.diagnosis.Tracing;
import de.christofreichardt.scala.shamir.NewtonPolynomial;
import de.christofreichardt.scala.shamir.package$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IndexedSeqOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.BigInt;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005A4AAD\b\u00011!AA\u0005\u0001BC\u0002\u0013\u0005Q\u0005\u0003\u00059\u0001\t\u0005\t\u0015!\u0003'\u0011!I\u0004A!b\u0001\n\u0003Q\u0004\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001b\t\u000bq\u0002A\u0011A\u001f\t\u000f\t\u0003!\u0019!C\u0001\u0007\"1q\t\u0001Q\u0001\n\u0011C\u0001\u0002\u0013\u0001\t\u0006\u0004%\t!\u0013\u0005\u0006\u001b\u0002!\tA\u0014\u0005\u0006)\u0002!\t!\u0016\u0005\u0006;\u0002!\tA\u0018\u0005\u0006?\u0002!\t\u0005\u0019\u0005\u0006S\u0002!\tE\u001b\u0002\u0014\u001d\u0016<Ho\u001c8J]R,'\u000f]8mCRLwN\u001c\u0006\u0003!E\taa\u001d5b[&\u0014(B\u0001\n\u0014\u0003\u0015\u00198-\u00197b\u0015\t!R#A\tdQJL7\u000f^8ge\u0016L7\r[1sIRT\u0011AF\u0001\u0003I\u0016\u001c\u0001aE\u0002\u00013y\u0001\"A\u0007\u000f\u000e\u0003mQ\u0011AE\u0005\u0003;m\u0011a!\u00118z%\u00164\u0007CA\u0010#\u001b\u0005\u0001#BA\u0011\u0012\u0003%!\u0017.Y4o_NL7/\u0003\u0002$A\t9AK]1dS:<\u0017\u0001E:vaB|'\u000f^5oOB{\u0017N\u001c;t+\u00051\u0003cA\u00140e9\u0011\u0001&\f\b\u0003S1j\u0011A\u000b\u0006\u0003W]\ta\u0001\u0010:p_Rt\u0014\"\u0001\n\n\u00059Z\u0012a\u00029bG.\fw-Z\u0005\u0003aE\u0012!\"\u00138eKb,GmU3r\u0015\tq3\u0004\u0005\u0003\u001bgU*\u0014B\u0001\u001b\u001c\u0005\u0019!V\u000f\u001d7feA\u0011qEN\u0005\u0003oE\u0012aAQ5h\u0013:$\u0018!E:vaB|'\u000f^5oOB{\u0017N\u001c;tA\u0005)\u0001O]5nKV\tQ'\u0001\u0004qe&lW\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007y\u0002\u0015\t\u0005\u0002@\u00015\tq\u0002C\u0003%\u000b\u0001\u0007a\u0005C\u0003:\u000b\u0001\u0007Q'\u0001\u0004eK\u001e\u0014X-Z\u000b\u0002\tB\u0011!$R\u0005\u0003\rn\u00111!\u00138u\u0003\u001d!Wm\u001a:fK\u0002\n\u0001C\\3xi>t\u0007k\u001c7z]>l\u0017.\u00197\u0016\u0003)\u0003\"aP&\n\u00051{!\u0001\u0005(foR|g\u000eU8ms:|W.[1m\u0003E\u0001\u0018-\u001b:XSN,G)\u001b4gKJ,g\u000e\u001e\u000b\u0003\u001fJ\u0003\"A\u0007)\n\u0005E[\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006'&\u0001\rAJ\u0001\u0007a>Lg\u000e^:\u0002'5,H\u000e^5qYf$\u0015N\u001a4fe\u0016t7-Z:\u0015\tU2\u0006L\u0017\u0005\u0006/*\u0001\r\u0001R\u0001\u0002S\")\u0011L\u0003a\u0001\t\u0006\t!\u000eC\u0003\\\u0015\u0001\u0007A,\u0001\u0002ygB\u0019qeL\u001b\u0002'\r|W\u000e];uK\u000e{WM\u001a4jG&,g\u000e^:\u0015\u0003q\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0002CB\u0011!M\u001a\b\u0003G\u0012\u0004\"!K\u000e\n\u0005\u0015\\\u0012A\u0002)sK\u0012,g-\u0003\u0002hQ\n11\u000b\u001e:j]\u001eT!!Z\u000e\u0002!\u001d,GoQ;se\u0016tG\u000f\u0016:bG\u0016\u0014H#A6\u0011\u00051tW\"A7\u000b\u0005\u0005\u001a\u0012BA8n\u00059\t%m\u001d;sC\u000e$HK]1dKJ\u0004")
public class NewtonInterpolation
implements Tracing {
    private NewtonPolynomial newtonPolynomial;
    private final IndexedSeq<Tuple2<BigInt, BigInt>> supportingPoints;
    private final BigInt prime;
    private final int degree;
    private volatile boolean bitmap$0;

    @Override
    public <T> T withTracer(String resultType, Object callee, String method, Function0<T> block) {
        return (T)Tracing.withTracer$(this, resultType, callee, method, block);
    }

    public IndexedSeq<Tuple2<BigInt, BigInt>> supportingPoints() {
        return this.supportingPoints;
    }

    public BigInt prime() {
        return this.prime;
    }

    public int degree() {
        return this.degree;
    }

    private NewtonPolynomial newtonPolynomial$lzycompute() {
        NewtonInterpolation newtonInterpolation = this;
        synchronized (newtonInterpolation) {
            if (!this.bitmap$0) {
                this.newtonPolynomial = new NewtonPolynomial(this.degree(), (IndexedSeq<BigInt>)((IndexedSeq)((IndexedSeqOps)this.supportingPoints().take(this.supportingPoints().length() - 1)).map((Function1 & Serializable)p -> (BigInt)p._1())), this.computeCoefficients(), this.prime());
                this.bitmap$0 = true;
            }
        }
        return this.newtonPolynomial;
    }

    public NewtonPolynomial newtonPolynomial() {
        return !this.bitmap$0 ? this.newtonPolynomial$lzycompute() : this.newtonPolynomial;
    }

    public boolean pairWiseDifferent(IndexedSeq<Tuple2<BigInt, BigInt>> points) {
        return this.check$1(points, Predef$.MODULE$.Set().empty());
    }

    public BigInt multiplyDifferences(int i, int j, IndexedSeq<BigInt> xs) {
        return (BigInt)this.withTracer("BigInt", this, "multiplyDifferences(i: Int, j: Int, xs: IndexedSeq[BigInt])", (Function0 & Serializable)() -> {
            AbstractTracer tracer = this.getCurrentTracer();
            tracer.out().printfIndentln("i = %d, j = %d, xs = (%s)", new Object[]{Predef$.MODULE$.int2Integer(i), Predef$.MODULE$.int2Integer(j), xs.mkString(",")});
            Predef$.MODULE$.require(i > j);
            return (BigInt)scala.package$.MODULE$.Range().inclusive(0, j).map((Function1 & Serializable)k -> NewtonInterpolation.$anonfun$multiplyDifferences$2(this, tracer, i, xs, BoxesRunTime.unboxToInt((Object)k))).foldLeft((Object)scala.package$.MODULE$.BigInt().apply(1), (Function2 & Serializable)(x1, x2) -> x1.$times(x2).mod(this.prime()));
        });
    }

    public IndexedSeq<BigInt> computeCoefficients() {
        AbstractTracer tracer = this.getCurrentTracer();
        Map memoCoefficients = (Map)Map$.MODULE$.empty();
        return (IndexedSeq)this.withTracer("IndexedSeq[BigInt]", this, "computeCoefficients()", (Function0 & Serializable)() -> {
            this.computeCoefficient$1(this.supportingPoints().length() - 1, tracer, memoCoefficients);
            return scala.package$.MODULE$.Range().apply(0, this.supportingPoints().length()).map((Function1 & Serializable)i -> NewtonInterpolation.$anonfun$computeCoefficients$7(memoCoefficients, BoxesRunTime.unboxToInt((Object)i)));
        });
    }

    public String toString() {
        return String.format("NewtonInterpolation[supportingPoints=(%s), prime=%s]", this.supportingPoints().mkString(","), this.prime());
    }

    @Override
    public AbstractTracer getCurrentTracer() {
        return TracerFactory.getInstance().getDefaultTracer();
    }

    private final boolean check$1(IndexedSeq ps, Set xs) {
        boolean bl;
        while (true) {
            if (ps.isEmpty()) {
                bl = true;
                break;
            }
            BigInt x = (BigInt)((Tuple2)ps.head())._1();
            if (xs.contains((Object)x)) {
                bl = false;
                break;
            }
            xs = (Set)xs.$plus((Object)x);
            ps = (IndexedSeq)ps.tail();
        }
        return bl;
    }

    public static final /* synthetic */ BigInt $anonfun$multiplyDifferences$2(NewtonInterpolation $this, AbstractTracer tracer$1, int i$1, IndexedSeq xs$1, int k) {
        tracer$1.out().printfIndentln("xs(%d) = %s, xs(%d) = %s", new Object[]{Predef$.MODULE$.int2Integer(i$1), xs$1.apply(i$1), Predef$.MODULE$.int2Integer(k), xs$1.apply(k)});
        return ((BigInt)xs$1.apply(i$1)).$minus((BigInt)xs$1.apply(k)).mod($this.prime());
    }

    public static final /* synthetic */ BigInt $anonfun$computeCoefficients$2(NewtonInterpolation $this, int index$1, AbstractTracer tracer$2, Map memoCoefficients$1, int i) {
        BigInt c = $this.computeCoefficient$1(i, tracer$2, memoCoefficients$1);
        BigInt product = i == 0 ? scala.package$.MODULE$.BigInt().apply(1) : $this.multiplyDifferences(index$1, i - 1, (IndexedSeq<BigInt>)((IndexedSeq)$this.supportingPoints().map((Function1 & Serializable)p -> (BigInt)p._1())));
        return c.$times(product);
    }

    private final BigInt computeCoefficient$1(int index, AbstractTracer tracer$2, Map memoCoefficients$1) {
        return (BigInt)this.withTracer("BigInt", this, "computeCoefficient(index: Int)", (Function0 & Serializable)() -> {
            BigInt bigInt;
            tracer$2.out().printfIndentln("index = %d, memoCoefficients = %s", new Object[]{Predef$.MODULE$.int2Integer(index), memoCoefficients$1});
            if (memoCoefficients$1.contains((Object)BoxesRunTime.boxToInteger((int)index))) {
                bigInt = (BigInt)memoCoefficients$1.apply((Object)BoxesRunTime.boxToInteger((int)index));
            } else if (index == 0) {
                memoCoefficients$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)index)), ((Tuple2)this.supportingPoints().apply(0))._2()));
                bigInt = (BigInt)memoCoefficients$1.apply((Object)BoxesRunTime.boxToInteger((int)index));
            } else {
                BigInt subtrahend = (BigInt)scala.package$.MODULE$.Range().inclusive(0, index - 1).map((Function1 & Serializable)i -> NewtonInterpolation.$anonfun$computeCoefficients$2(this, index, tracer$2, memoCoefficients$1, BoxesRunTime.unboxToInt((Object)i))).foldLeft((Object)scala.package$.MODULE$.BigInt().apply(0), (Function2 & Serializable)(t0, t1) -> t0.$plus(t1).mod(this.prime()));
                BigInt y = (BigInt)((Tuple2)this.supportingPoints().apply(index))._2();
                BigInt numerator = y.$minus(subtrahend).mod(this.prime());
                tracer$2.out().printfIndentln("numerator = %s", new Object[]{numerator});
                tracer$2.out().printfIndentln("index = %d", new Object[]{Predef$.MODULE$.int2Integer(index)});
                BigInt denominator = this.multiplyDifferences(index, index - 1, (IndexedSeq<BigInt>)((IndexedSeq)this.supportingPoints().map((Function1 & Serializable)p -> (BigInt)p._1())));
                tracer$2.out().printfIndentln("denominator = %s", new Object[]{denominator});
                BigInt c = numerator.$times(denominator.modInverse(this.prime())).mod(this.prime());
                memoCoefficients$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)index)), (Object)c));
                bigInt = (BigInt)memoCoefficients$1.apply((Object)BoxesRunTime.boxToInteger((int)index));
            }
            return bigInt;
        });
    }

    public static final /* synthetic */ BigInt $anonfun$computeCoefficients$7(Map memoCoefficients$1, int i) {
        return (BigInt)memoCoefficients$1.apply((Object)BoxesRunTime.boxToInteger((int)i));
    }

    public NewtonInterpolation(IndexedSeq<Tuple2<BigInt, BigInt>> supportingPoints, BigInt prime) {
        this.supportingPoints = supportingPoints;
        this.prime = prime;
        Tracing.$init$(this);
        Predef$.MODULE$.require(prime.isProbablePrime(package$.MODULE$.CERTAINTY()), (Function0 & Serializable)() -> String.format("%s isn't prime.", this.prime()));
        Predef$.MODULE$.require(this.pairWiseDifferent(supportingPoints), (Function0 & Serializable)() -> "Supporting points must be pairwise different and unambiguous.");
        this.degree = supportingPoints.length() - 1;
    }
}

