/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.scala.jws;

import de.christofreichardt.scala.jws.package$;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PublicKey;
import java.security.Signature;
import javax.crypto.SecretKey;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.IndexedSeq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t3Q\u0001C\u0005\u0002\u0002IA\u0001\u0002\u0007\u0001\u0003\u0006\u0004%\t!\u0007\u0005\tK\u0001\u0011\t\u0011)A\u00055!)a\u0005\u0001C\u0001O!91\u0006\u0001b\u0001\n\u0003a\u0003B\u0002\u001d\u0001A\u0003%Q\u0006C\u0003:\u0001\u0019\u0005!\bC\u0003<\u0001\u0011\u0005AHA\u0006K/N3VM]5gS\u0016\u0014(B\u0001\u0006\f\u0003\rQwo\u001d\u0006\u0003\u00195\tQa]2bY\u0006T!AD\b\u0002#\rD'/[:u_\u001a\u0014X-[2iCJ$GOC\u0001\u0011\u0003\t!Wm\u0001\u0001\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0017\u001b\u0005)\"\"\u0001\u0007\n\u0005])\"AB!osJ+g-A\u0002lS\u0012,\u0012A\u0007\t\u00037\tr!\u0001\b\u0011\u0011\u0005u)R\"\u0001\u0010\u000b\u0005}\t\u0012A\u0002\u001fs_>$h(\u0003\u0002\"+\u00051\u0001K]3eK\u001aL!a\t\u0013\u0003\rM#(/\u001b8h\u0015\t\tS#\u0001\u0003lS\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002)UA\u0011\u0011\u0006A\u0007\u0002\u0013!)\u0001d\u0001a\u00015\u0005aa/\u001a:jMfLgnZ&fsV\tQ\u0006\u0005\u0003\u0015]i\u0001\u0014BA\u0018\u0016\u0005\u0019!V\u000f\u001d7feA\u0011\u0011GN\u0007\u0002e)\u00111\u0007N\u0001\tg\u0016\u001cWO]5us*\tQ'\u0001\u0003kCZ\f\u0017BA\u001c3\u0005\rYU-_\u0001\u000em\u0016\u0014\u0018NZ=j]\u001e\\U-\u001f\u0011\u0002/I,GO]5fm\u00164VM]5gS\u000e\fG/[8o\u0017\u0016LH#A\u0017\u0002\rY,'/\u001b4z)\ti\u0004\t\u0005\u0002\u0015}%\u0011q(\u0006\u0002\b\u0005>|G.Z1o\u0011\u0015\tu\u00011\u0001\u001b\u00035\u0019\u0018n\u001a8j]\u001e|U\u000f\u001e9vi\u0002")
public abstract class JWSVerifier {
    private final String kid;
    private final Tuple2<String, Key> verifyingKey;

    public String kid() {
        return this.kid;
    }

    public Tuple2<String, Key> verifyingKey() {
        return this.verifyingKey;
    }

    public abstract Tuple2<String, Key> retrieveVerificationKey();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean verify(String signingOutput) {
        IndexedSeq splits = ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.refArrayOps((Object[])signingOutput.split("\\.")));
        JsonObject header = package$.MODULE$.decodeJson((String)splits.apply(0)).asJsonObject();
        JsonObject payload = package$.MODULE$.decodeJson((String)splits.apply(1)).asJsonObject();
        String encodedHeader = package$.MODULE$.encodeJson((JsonStructure)header);
        String encodedPayload = package$.MODULE$.encodeJson((JsonStructure)payload);
        String signingInput = new StringBuilder(1).append(encodedHeader).append(".").append(encodedPayload).toString();
        Tuple2<String, Key> tuple2 = this.verifyingKey();
        if (tuple2 == null) throw new MatchError(tuple2);
        Key key = (Key)tuple2._2();
        Key key2 = key;
        if (key2 instanceof SecretKey) {
            SecretKey secretKey = (SecretKey)key2;
            String signature = new StringBuilder(1).append(signingInput).append(".").append(new String(package$.MODULE$.encodeBytes(package$.MODULE$.hmac(secretKey, signingInput)), StandardCharsets.UTF_8)).toString();
            if (!BoxesRunTime.equals((Object)ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.refArrayOps((Object[])signature.split("\\."))).apply(2), (Object)splits.apply(2))) return false;
            return true;
        }
        if (!(key2 instanceof PublicKey)) throw new MatchError((Object)key2);
        PublicKey publicKey = (PublicKey)key2;
        Signature signatureAlgo = Signature.getInstance("SHA512withECDSA");
        signatureAlgo.initVerify(publicKey);
        signatureAlgo.update(signingInput.getBytes(StandardCharsets.UTF_8));
        byte[] rawSignature = package$.MODULE$.decodeBase64Str((String)splits.apply(2));
        boolean bl = signatureAlgo.verify(rawSignature);
        return bl;
    }

    public JWSVerifier(String kid) {
        this.kid = kid;
        this.verifyingKey = this.retrieveVerificationKey();
    }
}

