/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.scala.shamir;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.scala.combinations.BinomialCombinator;
import de.christofreichardt.scala.diagnosis.Tracing;
import de.christofreichardt.scala.shamir.Polynomial;
import de.christofreichardt.scala.shamir.SecretMerging;
import de.christofreichardt.scala.shamir.SecretMerging$;
import de.christofreichardt.scala.shamir.package$;
import de.christofreichardt.scala.utils.JsonPrettyPrinter;
import de.christofreichardt.scala.utils.RandomGenerator;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonValue;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.BigInt;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\u0005%h\u0001\u0002\u0016,\u0001QB\u0001\u0002\u0011\u0001\u0003\u0006\u0004%\t!\u0011\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\u0005\"Aa\t\u0001BC\u0002\u0013\u0005\u0011\t\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003C\u0011!A\u0005A!b\u0001\n\u0003I\u0005\u0002C-\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\t\u0011i\u0003!Q1A\u0005\u0002mC\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\u0006K\u0002!\tA\u001a\u0005\u0006K\u0002!\t!\u001c\u0005\u0006K\u0002!\ta\u001c\u0005\u0006K\u0002!\ta\u001d\u0005\u0006K\u0002!\tA\u001f\u0005\t\u0003\u001f\u0001!\u0019!C\u0001\u0003\"9\u0011\u0011\u0003\u0001!\u0002\u0013\u0011\u0005\u0002CA\n\u0001\t\u0007I\u0011A!\t\u000f\u0005U\u0001\u0001)A\u0005\u0005\"I\u0011q\u0003\u0001C\u0002\u0013\u0005\u0011\u0011\u0004\u0005\t\u0003C\u0001\u0001\u0015!\u0003\u0002\u001c!I\u00111\u0005\u0001C\u0002\u0013\u0005\u0011Q\u0005\u0005\t\u0003g\u0001\u0001\u0015!\u0003\u0002(!I\u0011Q\u0007\u0001C\u0002\u0013\u0005\u0011\u0011\u0004\u0005\t\u0003o\u0001\u0001\u0015!\u0003\u0002\u001c!I\u0011\u0011\b\u0001C\u0002\u0013\u0005\u00111\b\u0005\t\u0003\u0007\u0002\u0001\u0015!\u0003\u0002>!I\u0011Q\t\u0001C\u0002\u0013\u0005\u0011q\t\u0005\t\u0003#\u0002\u0001\u0015!\u0003\u0002J!I\u00111\u000b\u0001C\u0002\u0013\u0005\u0011Q\u000b\u0005\b\u0003/\u0002\u0001\u0015!\u0003\u0000\u0011)\tI\u0006\u0001EC\u0002\u0013\u0005\u00111\f\u0005\u000b\u0003[\u0002\u0001R1A\u0005\u0002\u0005=\u0004bBA<\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003s\u0002A\u0011AA>\u0011\u001d\ty\b\u0001C\u0003\u0003\u0003Cq!!&\u0001\t\u0003\t9\u0005C\u0004\u0002\u0018\u0002!\t!a\u001c\t\u000f\u0005e\u0003\u0001\"\u0001\u0002\u001a\"9\u0011q\u0014\u0001\u0005\u0002\u0005\u0005\u0006bBAZ\u0001\u0011\u0005\u0011Q\u0017\u0005\b\u0003g\u0003A\u0011AAj\u0011\u001d\tY\u000e\u0001C!\u0003;\u0014QbU3de\u0016$8\u000b[1sS:<'B\u0001\u0017.\u0003\u0019\u0019\b.Y7je*\u0011afL\u0001\u0006g\u000e\fG.\u0019\u0006\u0003aE\n\u0011c\u00195sSN$xN\u001a:fS\u000eD\u0017M\u001d3u\u0015\u0005\u0011\u0014A\u00013f\u0007\u0001\u00192\u0001A\u001b;!\t1\u0004(D\u00018\u0015\u0005q\u0013BA\u001d8\u0005\u0019\te.\u001f*fMB\u00111HP\u0007\u0002y)\u0011Q(L\u0001\nI&\fwM\\8tSNL!a\u0010\u001f\u0003\u000fQ\u0013\u0018mY5oO\u000611\u000f[1sKN,\u0012A\u0011\t\u0003m\rK!\u0001R\u001c\u0003\u0007%sG/A\u0004tQ\u0006\u0014Xm\u001d\u0011\u0002\u0013QD'/Z:i_2$\u0017A\u0003;ie\u0016\u001c\bn\u001c7eA\u0005Y1/Z2sKR\u0014\u0015\u0010^3t+\u0005Q\u0005cA&T-:\u0011A*\u0015\b\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001fN\na\u0001\u0010:p_Rt\u0014\"\u0001\u0018\n\u0005I;\u0014a\u00029bG.\fw-Z\u0005\u0003)V\u0013!\"\u00138eKb,GmU3r\u0015\t\u0011v\u0007\u0005\u00027/&\u0011\u0001l\u000e\u0002\u0005\u0005f$X-\u0001\u0007tK\u000e\u0014X\r\u001e\"zi\u0016\u001c\b%\u0001\u0004sC:$w.\\\u000b\u00029B\u0011QLY\u0007\u0002=*\u0011q\fY\u0001\tg\u0016\u001cWO]5us*\t\u0011-\u0001\u0003kCZ\f\u0017BA2_\u00051\u0019VmY;sKJ\u000bg\u000eZ8n\u0003\u001d\u0011\u0018M\u001c3p[\u0002\na\u0001P5oSRtD#B4jU.d\u0007C\u00015\u0001\u001b\u0005Y\u0003\"\u0002!\n\u0001\u0004\u0011\u0005\"\u0002$\n\u0001\u0004\u0011\u0005\"\u0002%\n\u0001\u0004Q\u0005\"\u0002.\n\u0001\u0004aFCA4o\u0011\u0015A%\u00021\u0001K)\u00119\u0007/\u001d:\t\u000b\u0001[\u0001\u0019\u0001\"\t\u000b\u0019[\u0001\u0019\u0001\"\t\u000b![\u0001\u0019\u0001&\u0015\t\u001d$XO\u001e\u0005\u0006\u00012\u0001\rA\u0011\u0005\u0006\r2\u0001\rA\u0011\u0005\u0006\u00112\u0001\ra\u001e\t\u0004ma4\u0016BA=8\u0005\u0015\t%O]1z)\u001197\u0010`?\t\u000b\u0001k\u0001\u0019\u0001\"\t\u000b\u0019k\u0001\u0019\u0001\"\t\u000byl\u0001\u0019A@\u0002\u0011A\f7o]<pe\u0012\u0004B!!\u0001\u0002\n9!\u00111AA\u0003!\tiu'C\u0002\u0002\b]\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0006\u0003\u001b\u0011aa\u0015;sS:<'bAA\u0004o\u0005\ta.\u0001\u0002oA\u0005\t1.\u0001\u0002lA\u0005\t1/\u0006\u0002\u0002\u001cA\u00191*!\b\n\u0007\u0005}QK\u0001\u0004CS\u001eLe\u000e^\u0001\u0003g\u0002\nqB]1oI>lw)\u001a8fe\u0006$xN]\u000b\u0003\u0003O\u0001B!!\u000b\u000205\u0011\u00111\u0006\u0006\u0004\u0003[i\u0013!B;uS2\u001c\u0018\u0002BA\u0019\u0003W\u0011qBU1oI>lw)\u001a8fe\u0006$xN]\u0001\u0011e\u0006tGm\\7HK:,'/\u0019;pe\u0002\nQ\u0001\u001d:j[\u0016\fa\u0001\u001d:j[\u0016\u0004\u0013A\u00039pYftw.\\5bYV\u0011\u0011Q\b\t\u0004Q\u0006}\u0012bAA!W\tQ\u0001k\u001c7z]>l\u0017.\u00197\u0002\u0017A|G.\u001f8p[&\fG\u000eI\u0001\fg\"\f'/\u001a)pS:$8/\u0006\u0002\u0002JA!1jUA&!\u001d1\u0014QJA\u000e\u00037I1!a\u00148\u0005\u0019!V\u000f\u001d7fe\u0005a1\u000f[1sKB{\u0017N\u001c;tA\u0005\u0011\u0011\u000eZ\u000b\u0002\u007f\u0006\u0019\u0011\u000e\u001a\u0011\u0002#MD\u0017M]3Q_&tGo]!t\u0015N|g.\u0006\u0002\u0002^A!\u0011qLA5\u001b\t\t\tG\u0003\u0003\u0002d\u0005\u0015\u0014\u0001\u00026t_:T!!a\u001a\u0002\u000b)\fg/\u0019=\n\t\u0005-\u0014\u0011\r\u0002\u000b\u0015N|gn\u00142kK\u000e$\u0018\u0001\u0003<fe&4\u0017.\u001a3\u0016\u0005\u0005E\u0004c\u0001\u001c\u0002t%\u0019\u0011QO\u001c\u0003\u000f\t{w\u000e\\3b]\u0006Y1\r[8pg\u0016\u0004&/[7f\u0003m\u0019\u0007n\\8tK\u000e\u000bgn\u001c8jG\u0006d7i\\3gM&\u001c\u0017.\u001a8ugV\u0011\u0011Q\u0010\t\u0005\u0017N\u000bY\"\u0001\tdQ>|7/\u001a)pYftw.\\5bYR!\u0011QHAB\u0011\u0019\t)I\ta\u0001\u0005\u00061A-Z4sK\u0016D3AIAE!\u0011\tY)!%\u000e\u0005\u00055%bAAHo\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0015Q\u0012\u0002\bi\u0006LGN]3d\u00035\u0019w.\u001c9vi\u0016\u001c\u0006.\u0019:fg\u0006Ia/\u001a:jMf\fE\u000e\u001c\u000b\u0005\u0003;\nY\nC\u0004\u0002\u001e\u0016\u0002\r!!\u0013\u0002\u0005A\u001c\u0018aE:iCJ,\u0007k\\5oiB\u000b'\u000f^5uS>tG\u0003BAR\u0003S\u0003RaSAS\u0003\u0013J1!a*V\u0005\u0011a\u0015n\u001d;\t\u000f\u0005-f\u00051\u0001\u0002.\u0006)1/\u001b>fgB!1*a,C\u0013\r\t\t,\u0016\u0002\t\u0013R,'/\u00192mK\u0006i1/\u0019<f!\u0006\u0014H/\u001b;j_:$b!a.\u0002>\u0006}\u0006c\u0001\u001c\u0002:&\u0019\u00111X\u001c\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003W;\u0003\u0019AAW\u0011\u001d\t\tm\na\u0001\u0003\u0007\fA\u0001]1uQB!\u0011QYAh\u001b\t\t9M\u0003\u0003\u0002J\u0006-\u0017\u0001\u00024jY\u0016T1!!4a\u0003\rq\u0017n\\\u0005\u0005\u0003#\f9M\u0001\u0003QCRDGCBA\\\u0003+\fI\u000eC\u0004\u0002,\"\u0002\r!a6\u0011\u0007YB(\tC\u0004\u0002B\"\u0002\r!a1\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a8\u0011\t\u0005\u0005\u0018q]\u0007\u0003\u0003GT1!!:a\u0003\u0011a\u0017M\\4\n\t\u0005-\u00111\u001d")
public class SecretSharing
implements Tracing {
    private JsonObject sharePointsAsJson;
    private boolean verified;
    private final int shares;
    private final int threshold;
    private final IndexedSeq<Object> secretBytes;
    private final SecureRandom random;
    private final int n;
    private final int k;
    private final BigInt s;
    private final RandomGenerator randomGenerator;
    private final BigInt prime;
    private final Polynomial polynomial;
    private final IndexedSeq<Tuple2<BigInt, BigInt>> sharePoints;
    private final String id;
    private volatile byte bitmap$0;

    @Override
    public <T> T withTracer(String resultTypeAsString, Object callee, String methodSignature, Function0<T> block) {
        return (T)Tracing.withTracer$(this, resultTypeAsString, callee, methodSignature, block);
    }

    @Override
    public AbstractTracer getCurrentTracer() {
        return Tracing.getCurrentTracer$(this);
    }

    public int shares() {
        return this.shares;
    }

    public int threshold() {
        return this.threshold;
    }

    public IndexedSeq<Object> secretBytes() {
        return this.secretBytes;
    }

    public SecureRandom random() {
        return this.random;
    }

    public int n() {
        return this.n;
    }

    public int k() {
        return this.k;
    }

    public BigInt s() {
        return this.s;
    }

    public RandomGenerator randomGenerator() {
        return this.randomGenerator;
    }

    public BigInt prime() {
        return this.prime;
    }

    public Polynomial polynomial() {
        return this.polynomial;
    }

    public IndexedSeq<Tuple2<BigInt, BigInt>> sharePoints() {
        return this.sharePoints;
    }

    public String id() {
        return this.id;
    }

    private JsonObject sharePointsAsJson$lzycompute() {
        SecretSharing secretSharing = this;
        synchronized (secretSharing) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.sharePointsAsJson = this.sharePointsAsJson(this.sharePoints());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.sharePointsAsJson;
    }

    public JsonObject sharePointsAsJson() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.sharePointsAsJson$lzycompute() : this.sharePointsAsJson;
    }

    private boolean verified$lzycompute() {
        SecretSharing secretSharing = this;
        synchronized (secretSharing) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.verified = this.verifyAll();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.verified;
    }

    public boolean verified() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.verified$lzycompute() : this.verified;
    }

    public BigInt choosePrime() {
        int BIT_OFFSET = 1;
        int bits = this.s().bitLength() + BIT_OFFSET;
        return scala.package$.MODULE$.BigInt().apply(bits, package$.MODULE$.CERTAINTY(), Random$.MODULE$.javaRandomToRandom((Random)this.random()));
    }

    public IndexedSeq<BigInt> chooseCanonicalCoefficients() {
        int bits = this.s().bitLength() * 2;
        return this.randomGenerator().bigIntStream(bits, this.prime()).take(this.k() - 1).toIndexedSeq();
    }

    public final Polynomial choosePolynomial(int degree) {
        Polynomial candidate;
        while ((candidate = new Polynomial((IndexedSeq<BigInt>)((IndexedSeq)this.chooseCanonicalCoefficients().$colon$plus((Object)this.s())), this.prime())).degree() != degree) {
        }
        return candidate;
    }

    public IndexedSeq<Tuple2<BigInt, BigInt>> computeShares() {
        int bits = this.s().bitLength() * 2;
        return this.randomGenerator().bigIntStream(bits, this.prime()).filterNot((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)SecretSharing.$anonfun$computeShares$1(x))).take(this.shares()).map((Function1 & Serializable)x -> new Tuple2(x, (Object)this.polynomial().evaluateAt((BigInt)x))).toIndexedSeq();
    }

    public boolean verifyAll() {
        BinomialCombinator combinator = new BinomialCombinator((IndexedSeq)scala.package$.MODULE$.IndexedSeq().range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)this.n()), (Integral)Numeric.IntIsIntegral$.MODULE$), this.k());
        return combinator.solutions().map((Function1 & Serializable)combination -> {
            IndexedSeq indices = combination.toIndexedSeq();
            IndexedSeq selectedPoints = (IndexedSeq)indices.map((Function1 & Serializable)index -> SecretSharing.$anonfun$verifyAll$2(this, BoxesRunTime.unboxToInt((Object)index)));
            SecretMerging merger = SecretMerging$.MODULE$.apply((IndexedSeq<Tuple2<BigInt, BigInt>>)selectedPoints, this.prime());
            return merger.secretBytes();
        }).forall((Function1 & Serializable)bytes -> BoxesRunTime.boxToBoolean((boolean)SecretSharing.$anonfun$verifyAll$3(this, bytes)));
    }

    public JsonObject sharePointsAsJson(IndexedSeq<Tuple2<BigInt, BigInt>> ps2) {
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        ps2.foreach((Function1 & Serializable)ps -> arrayBuilder.add(Json.createObjectBuilder().add("SharePoint", Json.createObjectBuilder().add("x", ((BigInt)ps._1()).bigInteger()).add("y", ((BigInt)ps._2()).bigInteger()))));
        return Json.createObjectBuilder().add("Id", this.id()).add("Prime", this.prime().bigInteger()).add("Threshold", this.threshold()).add("SharePoints", (JsonValue)arrayBuilder.build()).build();
    }

    public List<IndexedSeq<Tuple2<BigInt, BigInt>>> sharePointPartition(Iterable<Object> sizes) {
        Predef$.MODULE$.require(BoxesRunTime.unboxToInt((Object)sizes.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) == this.sharePoints().length(), (Function0 & Serializable)() -> "The sum of the shares of each slice doesn't match the number of overall shares.");
        Predef$.MODULE$.require(sizes.forall((Function1)(JFunction1.mcZI.sp & Serializable)s -> s <= this.k()), (Function0 & Serializable)() -> "A partition must not exceed the threshold.");
        return this.partition$1(sizes, this.sharePoints(), (List)Nil$.MODULE$);
    }

    public void savePartition(Iterable<Object> sizes, Path path) {
        Predef$.MODULE$.require(path.getParent().toFile().exists() && path.getParent().toFile().isDirectory());
        JsonPrettyPrinter prettyPrinter = new JsonPrettyPrinter();
        prettyPrinter.print(path.getParent().resolve(new StringBuilder(5).append(((Object)path.getFileName()).toString()).append(".json").toString()).toFile(), this.sharePointsAsJson());
        List<IndexedSeq<Tuple2<BigInt, BigInt>>> partition = this.sharePointPartition(sizes);
        ((List)partition.map((Function1 & Serializable)part -> this.sharePointsAsJson((IndexedSeq<Tuple2<BigInt, BigInt>>)part)).zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            SecretSharing.$anonfun$savePartition$2(prettyPrinter, path, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void savePartition(int[] sizes, Path path) {
        this.savePartition((Iterable<Object>)Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.reverse$extension(Predef$.MODULE$.intArrayOps(sizes))).toIterable(), path);
    }

    public String toString() {
        return String.format("SecretSharing[shares=%d, threshold=%d, s=%s, polynomial=%s, sharePoints=(%s)]", Predef$.MODULE$.int2Integer(this.shares()), Predef$.MODULE$.int2Integer(this.threshold()), this.s(), this.polynomial(), this.sharePoints().mkString(","));
    }

    public static final /* synthetic */ boolean $anonfun$computeShares$1(BigInt x) {
        BigInt bigInt = x;
        BigInt bigInt2 = scala.package$.MODULE$.BigInt().apply(0);
        return !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null);
    }

    public static final /* synthetic */ Tuple2 $anonfun$verifyAll$2(SecretSharing $this, int index) {
        return (Tuple2)$this.sharePoints().apply(index);
    }

    public static final /* synthetic */ boolean $anonfun$verifyAll$3(SecretSharing $this, IndexedSeq bytes) {
        IndexedSeq indexedSeq = bytes;
        IndexedSeq<Object> indexedSeq2 = $this.secretBytes();
        return !(indexedSeq != null ? !indexedSeq.equals(indexedSeq2) : indexedSeq2 != null);
    }

    private final List partition$1(Iterable sizes, IndexedSeq remainingPoints, List partitions) {
        while (!sizes.isEmpty()) {
            IndexedSeq indexedSeq = (IndexedSeq)remainingPoints.take(BoxesRunTime.unboxToInt((Object)sizes.head()));
            partitions = partitions.$colon$colon((Object)indexedSeq);
            remainingPoints = (IndexedSeq)remainingPoints.drop(BoxesRunTime.unboxToInt((Object)sizes.head()));
            sizes = (Iterable)sizes.tail();
        }
        return partitions;
    }

    public static final /* synthetic */ void $anonfun$savePartition$2(JsonPrettyPrinter prettyPrinter$1, Path path$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        JsonObject jsonObject = (JsonObject)tuple2._1();
        int i = tuple2._2$mcI$sp();
        prettyPrinter$1.print(path$1.getParent().resolve(new StringBuilder(6).append(((Object)path$1.getFileName()).toString()).append("-").append(i).append(".json").toString()).toFile(), jsonObject);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public SecretSharing(int shares, int threshold, IndexedSeq<Object> secretBytes, SecureRandom random) {
        this.shares = shares;
        this.threshold = threshold;
        this.secretBytes = secretBytes;
        this.random = random;
        Tracing.$init$(this);
        this.n = shares;
        this.k = threshold;
        this.s = package$.MODULE$.bytes2BigInt(secretBytes);
        this.randomGenerator = new RandomGenerator(random);
        this.prime = this.choosePrime();
        this.polynomial = this.choosePolynomial(this.k() - 1);
        this.sharePoints = this.computeShares();
        this.id = UUID.randomUUID().toString();
        Predef$.MODULE$.require(this.n() >= 2 && this.k() >= 2, (Function0 & Serializable)() -> "We need at least two shares, otherwise we wouldn't need shares at all.");
        Predef$.MODULE$.require(this.k() <= this.n(), (Function0 & Serializable)() -> "The threshold must be less than or equal to the number of shares.");
        Predef$.MODULE$.require(this.polynomial().degree() == this.k() - 1);
    }

    public SecretSharing(IndexedSeq<Object> secretBytes) {
        this(6, 3, secretBytes, new SecureRandom());
    }

    public SecretSharing(int shares, int threshold, IndexedSeq<Object> secretBytes) {
        this(shares, threshold, secretBytes, new SecureRandom());
    }

    public SecretSharing(int shares, int threshold, byte[] secretBytes) {
        this(shares, threshold, (IndexedSeq<Object>)ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.byteArrayOps(secretBytes)), new SecureRandom());
    }

    public SecretSharing(int shares, int threshold, String password) {
        this(shares, threshold, (IndexedSeq<Object>)ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.byteArrayOps(password.getBytes(StandardCharsets.UTF_8))), new SecureRandom());
    }
}

