/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.scala.shamir;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.TracerFactory;
import de.christofreichardt.scala.diagnosis.Tracing;
import de.christofreichardt.scala.shamir.package$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.math.BigInt;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\ra\u0001\u0002\u000b\u0016\u0001yA\u0001B\u000b\u0001\u0003\u0006\u0004%\ta\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005Y!A\u0001\u0007\u0001BC\u0002\u0013\u0005\u0011\u0007\u0003\u0005B\u0001\t\u0005\t\u0015!\u00033\u0011!\u0011\u0005A!b\u0001\n\u0003\t\u0004\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u0011\u0011\u0003!Q1A\u0005\u0002\u0015C\u0001B\u0012\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\u0006\u000f\u0002!\t\u0001\u0013\u0005\b\u001f\u0002\u0011\r\u0011\"\u0001,\u0011\u0019\u0001\u0006\u0001)A\u0005Y!9\u0011\u000b\u0001b\u0001\n\u0003\u0011\u0006BB0\u0001A\u0003%1\u000bC\u0004a\u0001\t\u0007I\u0011\u0001*\t\r\u0005\u0004\u0001\u0015!\u0003T\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0011\u0015a\u0007\u0001\"\u0001n\u0011\u0015\u0001\b\u0001\"\u0011r\u0011\u0015Q\b\u0001\"\u0011|\u0005AqUm\u001e;p]B{G.\u001f8p[&\fGN\u0003\u0002\u0017/\u000511\u000f[1nSJT!\u0001G\r\u0002\u000bM\u001c\u0017\r\\1\u000b\u0005iY\u0012!E2ie&\u001cHo\u001c4sK&\u001c\u0007.\u0019:ei*\tA$\u0001\u0002eK\u000e\u00011c\u0001\u0001 IA\u0011\u0001EI\u0007\u0002C)\t\u0001$\u0003\u0002$C\t1\u0011I\\=SK\u001a\u0004\"!\n\u0015\u000e\u0003\u0019R!aJ\f\u0002\u0013\u0011L\u0017m\u001a8pg&\u001c\u0018BA\u0015'\u0005\u001d!&/Y2j]\u001e\fa\u0001Z3he\u0016,W#\u0001\u0017\u0011\u0005\u0001j\u0013B\u0001\u0018\"\u0005\rIe\u000e^\u0001\bI\u0016<'/Z3!\u0003\u0015\u0011\u0017m]5t+\u0005\u0011\u0004cA\u001a<}9\u0011A'\u000f\b\u0003kaj\u0011A\u000e\u0006\u0003ou\ta\u0001\u0010:p_Rt\u0014\"\u0001\r\n\u0005i\n\u0013a\u00029bG.\fw-Z\u0005\u0003yu\u0012!\"\u00138eKb,GmU3r\u0015\tQ\u0014\u0005\u0005\u00024\u007f%\u0011\u0001)\u0010\u0002\u0007\u0005&<\u0017J\u001c;\u0002\r\t\f7/[:!\u00031\u0019w.\u001a4gS\u000eLWM\u001c;t\u00035\u0019w.\u001a4gS\u000eLWM\u001c;tA\u0005)\u0001O]5nKV\ta(\u0001\u0004qe&lW\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b%[E*\u0014(\u0011\u0005)\u0003Q\"A\u000b\t\u000b)J\u0001\u0019\u0001\u0017\t\u000bAJ\u0001\u0019\u0001\u001a\t\u000b\tK\u0001\u0019\u0001\u001a\t\u000b\u0011K\u0001\u0019\u0001 \u0002\u00039\f!A\u001c\u0011\u0002\u0003\r,\u0012a\u0015\t\u0004)fSV\"A+\u000b\u0005Y;\u0016!C5n[V$\u0018M\u00197f\u0015\tA\u0016%\u0001\u0006d_2dWm\u0019;j_:L!\u0001P+\u0011\u0005msV\"\u0001/\u000b\u0005u\u000b\u0013\u0001B7bi\"L!\u0001\u0011/\u0002\u0005\r\u0004\u0013A\u0001=y\u0003\rA\b\u0010I\u0001\u0012a\u0006L'o^5tK\u0012KgMZ3sK:$HC\u00013h!\t\u0001S-\u0003\u0002gC\t9!i\\8mK\u0006t\u0007\"\u00025\u0011\u0001\u0004I\u0017A\u0002<bYV,7\u000fE\u00024UzJ!a[\u001f\u0003\t1K7\u000f^\u0001\u000bKZ\fG.^1uK\u0006#HC\u0001 o\u0011\u0015y\u0017\u00031\u0001?\u0003\u0005A\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003I\u0004\"a\u001d=\u000e\u0003QT!!\u001e<\u0002\t1\fgn\u001a\u0006\u0002o\u0006!!.\u0019<b\u0013\tIHO\u0001\u0004TiJLgnZ\u0001\u0011O\u0016$8)\u001e:sK:$HK]1dKJ$\u0012\u0001 \t\u0003{~l\u0011A \u0006\u0003OeI1!!\u0001\u007f\u00059\t%m\u001d;sC\u000e$HK]1dKJ\u0004")
public class NewtonPolynomial
implements Tracing {
    private final int degree;
    private final IndexedSeq<BigInt> basis;
    private final IndexedSeq<BigInt> coefficients;
    private final BigInt prime;
    private final int n;
    private final IndexedSeq<BigInt> c;
    private final IndexedSeq<BigInt> xx;

    @Override
    public <T> T withTracer(String resultTypeAsString, Object callee, String methodSignature, Function0<T> block) {
        return (T)Tracing.withTracer$(this, resultTypeAsString, callee, methodSignature, block);
    }

    public int degree() {
        return this.degree;
    }

    public IndexedSeq<BigInt> basis() {
        return this.basis;
    }

    public IndexedSeq<BigInt> coefficients() {
        return this.coefficients;
    }

    public BigInt prime() {
        return this.prime;
    }

    public int n() {
        return this.n;
    }

    public IndexedSeq<BigInt> c() {
        return this.c;
    }

    public IndexedSeq<BigInt> xx() {
        return this.xx;
    }

    public boolean pairwiseDifferent(List<BigInt> values) {
        boolean bl;
        SeqOps seqOps;
        List<BigInt> list = values;
        if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
            bl = true;
        } else if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            BigInt head = (BigInt)colon2.head();
            List tail = colon2.next$access$1();
            bl = tail.exists((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)NewtonPolynomial.$anonfun$pairwiseDifferent$1(head, v))) ? false : this.pairwiseDifferent((List<BigInt>)tail);
        } else {
            throw new MatchError(list);
        }
        return bl;
    }

    public BigInt evaluateAt(BigInt x) {
        AbstractTracer tracer = this.getCurrentTracer();
        return (BigInt)this.withTracer("BigInt", this, "evaluateAt(x: BigInt)", (Function0 & Serializable)() -> {
            tracer.out().printfIndentln("x = %s", new Object[]{x});
            return this.evaluate$1(0, tracer, x);
        });
    }

    public String toString() {
        return String.format("NewtonPolynomial[degree=%d, c=(%s), x=(%s), prime=%s]", Predef$.MODULE$.int2Integer(this.n()), this.c().mkString(","), this.xx().mkString(","), this.prime());
    }

    @Override
    public AbstractTracer getCurrentTracer() {
        return TracerFactory.getInstance().getDefaultTracer();
    }

    public static final /* synthetic */ boolean $anonfun$pairwiseDifferent$1(BigInt head$1, BigInt v) {
        BigInt bigInt = v;
        BigInt bigInt2 = head$1;
        return !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null);
    }

    private final BigInt evaluate$1(int m, AbstractTracer tracer$1, BigInt x$1) {
        tracer$1.out().printfIndentln("m = %d", new Object[]{Predef$.MODULE$.int2Integer(m)});
        return m == this.n() ? (BigInt)this.c().apply(this.n()) : this.evaluate$1(m + 1, tracer$1, x$1).$times(x$1.$minus((BigInt)this.xx().apply(m))).$plus((BigInt)this.c().apply(m)).mod(this.prime());
    }

    public NewtonPolynomial(int degree, IndexedSeq<BigInt> basis, IndexedSeq<BigInt> coefficients, BigInt prime) {
        this.degree = degree;
        this.basis = basis;
        this.coefficients = coefficients;
        this.prime = prime;
        Tracing.$init$(this);
        Predef$.MODULE$.require(prime.isProbablePrime(package$.MODULE$.CERTAINTY()));
        this.n = degree;
        Predef$.MODULE$.require(basis.length() == this.n());
        Predef$.MODULE$.require(coefficients.length() == this.n() + 1);
        this.c = (IndexedSeq)coefficients.map((Function1 & Serializable)b -> b.mod(this.prime()));
        this.xx = (IndexedSeq)basis.map((Function1 & Serializable)b -> b.mod(this.prime()));
        Predef$.MODULE$.require(this.pairwiseDifferent((List<BigInt>)this.xx().toList()), (Function0 & Serializable)() -> "Basis values must be pairwise different.");
    }
}

