/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.scala.shamir;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.TracerFactory;
import de.christofreichardt.scala.diagnosis.Tracing;
import de.christofreichardt.scala.shamir.package$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.BigInt;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00154Aa\u0003\u0007\u0001+!A\u0011\u0005\u0001BC\u0002\u0013\u0005!\u0005\u0003\u00056\u0001\t\u0005\t\u0015!\u0003$\u0011!1\u0004A!b\u0001\n\u00039\u0004\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u000be\u0002A\u0011\u0001\u001e\t\u000b}\u0002A\u0011\u0001!\t\u000b\u0019\u0003A\u0011A$\t\u000bI\u0003A\u0011A*\t\u000bQ\u0003A\u0011I+\t\u000by\u0003A\u0011I0\u0003'9+w\u000f^8o\u0013:$XM\u001d9pY\u0006$\u0018n\u001c8\u000b\u00055q\u0011AB:iC6L'O\u0003\u0002\u0010!\u0005)1oY1mC*\u0011\u0011CE\u0001\u0012G\"\u0014\u0018n\u001d;pMJ,\u0017n\u00195be\u0012$(\"A\n\u0002\u0005\u0011,7\u0001A\n\u0004\u0001YY\u0002CA\f\u001a\u001b\u0005A\"\"A\b\n\u0005iA\"AB!osJ+g\r\u0005\u0002\u001d?5\tQD\u0003\u0002\u001f\u001d\u0005IA-[1h]>\u001c\u0018n]\u0005\u0003Au\u0011q\u0001\u0016:bG&tw-\u0001\ttkB\u0004xN\u001d;j]\u001e\u0004v.\u001b8ugV\t1\u0005E\u0002%Y=r!!\n\u0016\u000f\u0005\u0019JS\"A\u0014\u000b\u0005!\"\u0012A\u0002\u001fs_>$h(C\u0001\u0010\u0013\tY\u0003$A\u0004qC\u000e\\\u0017mZ3\n\u00055r#AC%oI\u0016DX\rZ*fc*\u00111\u0006\u0007\t\u0005/A\u0012$'\u0003\u000221\t1A+\u001e9mKJ\u0002\"\u0001J\u001a\n\u0005Qr#A\u0002\"jO&sG/A\ttkB\u0004xN\u001d;j]\u001e\u0004v.\u001b8ug\u0002\nQ\u0001\u001d:j[\u0016,\u0012AM\u0001\u0007aJLW.\u001a\u0011\u0002\rqJg.\u001b;?)\rYTH\u0010\t\u0003y\u0001i\u0011\u0001\u0004\u0005\u0006C\u0015\u0001\ra\t\u0005\u0006m\u0015\u0001\rAM\u0001\u0012a\u0006L'oV5tK\u0012KgMZ3sK:$HCA!E!\t9\")\u0003\u0002D1\t9!i\\8mK\u0006t\u0007\"B#\u0007\u0001\u0004\u0019\u0013A\u00029pS:$8/A\nnk2$\u0018\u000e\u001d7z\t&4g-\u001a:f]\u000e,7\u000f\u0006\u00033\u00116{\u0005\"B%\b\u0001\u0004Q\u0015!A5\u0011\u0005]Y\u0015B\u0001'\u0019\u0005\rIe\u000e\u001e\u0005\u0006\u001d\u001e\u0001\rAS\u0001\u0002U\")\u0001k\u0002a\u0001#\u0006\u0011\u0001p\u001d\t\u0004I1\u0012\u0014aE2p[B,H/Z\"pK\u001a4\u0017nY5f]R\u001cH#A)\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012A\u0016\t\u0003/rk\u0011\u0001\u0017\u0006\u00033j\u000bA\u0001\\1oO*\t1,\u0001\u0003kCZ\f\u0017BA/Y\u0005\u0019\u0019FO]5oO\u0006\u0001r-\u001a;DkJ\u0014XM\u001c;Ue\u0006\u001cWM\u001d\u000b\u0002AB\u0011\u0011mY\u0007\u0002E*\u0011a\u0004E\u0005\u0003I\n\u0014a\"\u00112tiJ\f7\r\u001e+sC\u000e,'\u000f")
public class NewtonInterpolation
implements Tracing {
    private final IndexedSeq<Tuple2<BigInt, BigInt>> supportingPoints;
    private final BigInt prime;

    @Override
    public <T> T withTracer(String resultTypeAsString, Object callee, String methodSignature, Function0<T> block) {
        return (T)Tracing.withTracer$(this, resultTypeAsString, callee, methodSignature, block);
    }

    public IndexedSeq<Tuple2<BigInt, BigInt>> supportingPoints() {
        return this.supportingPoints;
    }

    public BigInt prime() {
        return this.prime;
    }

    public boolean pairWiseDifferent(IndexedSeq<Tuple2<BigInt, BigInt>> points) {
        return this.check$1(points, Predef$.MODULE$.Set().empty());
    }

    public BigInt multiplyDifferences(int i, int j, IndexedSeq<BigInt> xs) {
        return (BigInt)this.withTracer("BigInt", this, "multiplyDifferences(i: Int, j: Int, xs: IndexedSeq[BigInt])", (Function0 & Serializable)() -> {
            AbstractTracer tracer = this.getCurrentTracer();
            tracer.out().printfIndentln("i = %d, j = %d, xs = (%s)", new Object[]{Predef$.MODULE$.int2Integer(i), Predef$.MODULE$.int2Integer(j), xs.mkString(",")});
            Predef$.MODULE$.require(i > j);
            return (BigInt)scala.package$.MODULE$.Range().inclusive(0, j).map((Function1 & Serializable)k -> NewtonInterpolation.$anonfun$multiplyDifferences$2(this, tracer, i, xs, BoxesRunTime.unboxToInt((Object)k))).foldLeft((Object)scala.package$.MODULE$.BigInt().apply(1), (Function2 & Serializable)(x1, x2) -> x1.$times(x2).mod(this.prime()));
        });
    }

    public IndexedSeq<BigInt> computeCoefficients() {
        AbstractTracer tracer = this.getCurrentTracer();
        Map memoCoefficients = (Map)Map$.MODULE$.empty();
        return (IndexedSeq)this.withTracer("IndexedSeq[BigInt]", this, "computeCoefficients()", (Function0 & Serializable)() -> {
            this.computeCoefficient$1(this.supportingPoints().length() - 1, tracer, memoCoefficients);
            return scala.package$.MODULE$.Range().apply(0, this.supportingPoints().length()).map((Function1 & Serializable)i -> NewtonInterpolation.$anonfun$computeCoefficients$7(memoCoefficients, BoxesRunTime.unboxToInt((Object)i)));
        });
    }

    public String toString() {
        return String.format("NewtonInterpolation[supportingPoints=(%s), prime=%s]", this.supportingPoints().mkString(","), this.prime());
    }

    @Override
    public AbstractTracer getCurrentTracer() {
        return TracerFactory.getInstance().getDefaultTracer();
    }

    private final boolean check$1(IndexedSeq ps, Set xs) {
        boolean bl;
        while (true) {
            if (ps.isEmpty()) {
                bl = true;
                break;
            }
            BigInt x = (BigInt)((Tuple2)ps.head())._1();
            if (xs.contains((Object)x)) {
                bl = false;
                break;
            }
            xs = (Set)xs.$plus((Object)x);
            ps = (IndexedSeq)ps.tail();
        }
        return bl;
    }

    public static final /* synthetic */ BigInt $anonfun$multiplyDifferences$2(NewtonInterpolation $this, AbstractTracer tracer$1, int i$1, IndexedSeq xs$1, int k) {
        tracer$1.out().printfIndentln("xs(%d) = %s, xs(%d) = %s", new Object[]{Predef$.MODULE$.int2Integer(i$1), xs$1.apply(i$1), Predef$.MODULE$.int2Integer(k), xs$1.apply(k)});
        return ((BigInt)xs$1.apply(i$1)).$minus((BigInt)xs$1.apply(k)).mod($this.prime());
    }

    public static final /* synthetic */ BigInt $anonfun$computeCoefficients$2(NewtonInterpolation $this, int index$1, AbstractTracer tracer$2, Map memoCoefficients$1, int i) {
        BigInt c = $this.computeCoefficient$1(i, tracer$2, memoCoefficients$1);
        BigInt product = i == 0 ? scala.package$.MODULE$.BigInt().apply(1) : $this.multiplyDifferences(index$1, i - 1, (IndexedSeq<BigInt>)((IndexedSeq)$this.supportingPoints().map((Function1 & Serializable)p -> (BigInt)p._1())));
        return c.$times(product);
    }

    private final BigInt computeCoefficient$1(int index, AbstractTracer tracer$2, Map memoCoefficients$1) {
        return (BigInt)this.withTracer("BigInt", this, "computeCoefficient(index: Int)", (Function0 & Serializable)() -> {
            BigInt bigInt;
            tracer$2.out().printfIndentln("index = %d, memoCoefficients = %s", new Object[]{Predef$.MODULE$.int2Integer(index), memoCoefficients$1});
            if (memoCoefficients$1.contains((Object)BoxesRunTime.boxToInteger((int)index))) {
                bigInt = (BigInt)memoCoefficients$1.apply((Object)BoxesRunTime.boxToInteger((int)index));
            } else if (index == 0) {
                memoCoefficients$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)index)), ((Tuple2)this.supportingPoints().apply(0))._2()));
                bigInt = (BigInt)memoCoefficients$1.apply((Object)BoxesRunTime.boxToInteger((int)index));
            } else {
                BigInt subtrahend = (BigInt)scala.package$.MODULE$.Range().inclusive(0, index - 1).map((Function1 & Serializable)i -> NewtonInterpolation.$anonfun$computeCoefficients$2(this, index, tracer$2, memoCoefficients$1, BoxesRunTime.unboxToInt((Object)i))).foldLeft((Object)scala.package$.MODULE$.BigInt().apply(0), (Function2 & Serializable)(t0, t1) -> t0.$plus(t1).mod(this.prime()));
                BigInt y = (BigInt)((Tuple2)this.supportingPoints().apply(index))._2();
                BigInt numerator = y.$minus(subtrahend).mod(this.prime());
                tracer$2.out().printfIndentln("numerator = %s", new Object[]{numerator});
                tracer$2.out().printfIndentln("index = %d", new Object[]{Predef$.MODULE$.int2Integer(index)});
                BigInt denominator = this.multiplyDifferences(index, index - 1, (IndexedSeq<BigInt>)((IndexedSeq)this.supportingPoints().map((Function1 & Serializable)p -> (BigInt)p._1())));
                tracer$2.out().printfIndentln("denominator = %s", new Object[]{denominator});
                BigInt c = numerator.$times(denominator.modInverse(this.prime())).mod(this.prime());
                memoCoefficients$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)index)), (Object)c));
                bigInt = (BigInt)memoCoefficients$1.apply((Object)BoxesRunTime.boxToInteger((int)index));
            }
            return bigInt;
        });
    }

    public static final /* synthetic */ BigInt $anonfun$computeCoefficients$7(Map memoCoefficients$1, int i) {
        return (BigInt)memoCoefficients$1.apply((Object)BoxesRunTime.boxToInteger((int)i));
    }

    public NewtonInterpolation(IndexedSeq<Tuple2<BigInt, BigInt>> supportingPoints, BigInt prime) {
        this.supportingPoints = supportingPoints;
        this.prime = prime;
        Tracing.$init$(this);
        Predef$.MODULE$.require(prime.isProbablePrime(package$.MODULE$.CERTAINTY()), (Function0 & Serializable)() -> String.format("%s isn't prime.", this.prime()));
        Predef$.MODULE$.require(this.pairWiseDifferent(supportingPoints), (Function0 & Serializable)() -> "Supporting points must be pairwise different and unambiguous.");
    }
}

