/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.scala.jws;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.scala.diagnosis.Tracing;
import de.christofreichardt.scala.jws.package$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import scala.Function0;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005u4Q!\u0004\b\u0002\u0002]A\u0001b\t\u0001\u0003\u0006\u0004%\t\u0001\n\u0005\ta\u0001\u0011\t\u0011)A\u0005K!)\u0011\u0007\u0001C\u0001e!9a\u0007\u0001b\u0001\n\u00039\u0004BB\"\u0001A\u0003%\u0001\bC\u0004E\u0001\t\u0007I\u0011A#\t\rM\u0003\u0001\u0015!\u0003G\u0011\u0015!\u0006A\"\u0001V\u0011\u00151\u0006\u0001\"\u0001X\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0011\u0015\u0011\b\u0001\"\u0001t\u0011\u00151\b\u0001\"\u0001x\u0005AQ5o\u001c8XK\n\u001c\u0016n\u001a8biV\u0014XM\u0003\u0002\u0010!\u0005\u0019!n^:\u000b\u0005E\u0011\u0012!B:dC2\f'BA\n\u0015\u0003E\u0019\u0007N]5ti>4'/Z5dQ\u0006\u0014H\r\u001e\u0006\u0002+\u0005\u0011A-Z\u0002\u0001'\r\u0001\u0001$\b\t\u00033mi\u0011A\u0007\u0006\u0002#%\u0011AD\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005y\tS\"A\u0010\u000b\u0005\u0001\u0002\u0012!\u00033jC\u001etwn]5t\u0013\t\u0011sDA\u0004Ue\u0006\u001c\u0017N\\4\u0002\u0007-LG-F\u0001&!\t1SF\u0004\u0002(WA\u0011\u0001FG\u0007\u0002S)\u0011!FF\u0001\u0007yI|w\u000e\u001e \n\u00051R\u0012A\u0002)sK\u0012,g-\u0003\u0002/_\t11\u000b\u001e:j]\u001eT!\u0001\f\u000e\u0002\t-LG\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005M*\u0004C\u0001\u001b\u0001\u001b\u0005q\u0001\"B\u0012\u0004\u0001\u0004)\u0013AC:jO:LgnZ&fsV\t\u0001\b\u0005\u0003\u001as\u0015Z\u0014B\u0001\u001e\u001b\u0005\u0019!V\u000f\u001d7feA\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\tg\u0016\u001cWO]5us*\t\u0001)\u0001\u0003kCZ\f\u0017B\u0001\">\u0005\rYU-_\u0001\fg&<g.\u001b8h\u0017\u0016L\b%A\u0004bY\u001e|W*\u00199\u0016\u0003\u0019\u0003Ba\u0012'O\u001d6\t\u0001J\u0003\u0002J\u0015\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003\u0017j\t!bY8mY\u0016\u001cG/[8o\u0013\ti\u0005JA\u0002NCB\u0004\"a\u0014*\u000e\u0003AS!!U \u0002\t1\fgnZ\u0005\u0003]A\u000b\u0001\"\u00197h_6\u000b\u0007\u000fI\u0001\u0013e\u0016$(/[3wKNKwM\\5oO.+\u0017\u0010F\u00019\u0003-\u0011W/\u001b7e\u0011\u0016\fG-\u001a:\u0016\u0003a\u0003\"!\u00170\u000e\u0003iS!a\u0017/\u0002\t)\u001cxN\u001c\u0006\u0002;\u0006)!.\u0019<bq&\u0011qL\u0017\u0002\u000b\u0015N|gn\u00142kK\u000e$\u0018\u0001\u00025nC\u000e$2A\u00195q!\rI2-Z\u0005\u0003Ij\u0011Q!\u0011:sCf\u0004\"!\u00074\n\u0005\u001dT\"\u0001\u0002\"zi\u0016DQ!\u001b\u0006A\u0002)\f\u0011b]3de\u0016$8*Z=\u0011\u0005-tW\"\u00017\u000b\u00055d\u0016AB2ssB$x.\u0003\u0002pY\nI1+Z2sKR\\U-\u001f\u0005\u0006c*\u0001\r!J\u0001\rg&<g.\u001b8h\u0013:\u0004X\u000f^\u0001\u0005g&<g\u000e\u0006\u0002&i\")Qo\u0003a\u00011\u00069\u0001/Y=m_\u0006$\u0017A\u0002<fe&4\u0017\u0010\u0006\u0002ywB\u0011\u0011$_\u0005\u0003uj\u0011qAQ8pY\u0016\fg\u000eC\u0003}\u0019\u0001\u0007Q%A\u0007tS\u001et\u0017N\\4PkR\u0004X\u000f\u001e")
public abstract class JsonWebSignature
implements Tracing {
    private final String kid;
    private final Tuple2<String, Key> signingKey;
    private final Map<String, String> algoMap;

    @Override
    public <T> T withTracer(String resultTypeAsString, Object callee, String methodSignature, Function0<T> block) {
        return (T)Tracing.withTracer$(this, resultTypeAsString, callee, methodSignature, block);
    }

    @Override
    public AbstractTracer getCurrentTracer() {
        return Tracing.getCurrentTracer$(this);
    }

    public String kid() {
        return this.kid;
    }

    public Tuple2<String, Key> signingKey() {
        return this.signingKey;
    }

    public Map<String, String> algoMap() {
        return this.algoMap;
    }

    public abstract Tuple2<String, Key> retrieveSigningKey();

    public JsonObject buildHeader() {
        return (JsonObject)this.withTracer("JsonObject", this, "buildHeader()", (Function0 & Serializable)() -> {
            AbstractTracer tracer = this.getCurrentTracer();
            tracer.out().printfIndentln("signingKey = (%s,(%s))", new Object[]{this.signingKey()._1(), de.christofreichardt.scala.package$.MODULE$.formatBytes((Iterable<Object>)Predef$.MODULE$.wrapByteArray(((Key)this.signingKey()._2()).getEncoded()))});
            Tuple2<String, Key> tuple2 = this.signingKey();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Key key = (Key)tuple2._2();
            JsonObject jsonObject = Json.createObjectBuilder().add("typ", "json").add("alg", (String)this.algoMap().apply((Object)key.getAlgorithm())).build();
            return jsonObject;
        });
    }

    public byte[] hmac(SecretKey secretKey, String signingInput) {
        Mac mac = Mac.getInstance(secretKey.getAlgorithm());
        mac.init(secretKey);
        return mac.doFinal(signingInput.getBytes(StandardCharsets.UTF_8));
    }

    public String sign(JsonObject payload) {
        return (String)this.withTracer("String", this, "sign(payload: JsonObject)", (Function0 & Serializable)() -> {
            String string;
            AbstractTracer tracer = this.getCurrentTracer();
            tracer.out().printfIndentln("payload = %s", new Object[]{payload});
            JsonObject header = this.buildHeader();
            String encodedHeader = package$.MODULE$.encodeJson((JsonStructure)header);
            String encodedPayload = package$.MODULE$.encodeJson((JsonStructure)payload);
            String signingInput = new StringBuilder(1).append(encodedHeader).append(".").append(encodedPayload).toString();
            Tuple2<String, Key> tuple2 = this.signingKey();
            if (tuple2 != null) {
                Key key = (Key)tuple2._2();
                Key key2 = key;
                if (!(key2 instanceof SecretKey)) {
                    throw new MatchError((Object)key2);
                }
                SecretKey secretKey = (SecretKey)key2;
                string = new StringBuilder(1).append(signingInput).append(".").append(new String(package$.MODULE$.encodeBytes(this.hmac(secretKey, signingInput)), StandardCharsets.UTF_8)).toString();
            } else {
                throw new MatchError(tuple2);
            }
            String string2 = string;
            return string2;
        });
    }

    public boolean verify(String signingOutput) {
        return BoxesRunTime.unboxToBoolean(this.withTracer("Boolean", this, "verify(signingOutput: String)", (Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            String string;
            AbstractTracer tracer = this.getCurrentTracer();
            IndexedSeq splits = ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.refArrayOps((Object[])signingOutput.split("\\.")));
            tracer.out().printfIndentln("splits = (%s)", new Object[]{splits});
            JsonObject header = package$.MODULE$.decodeJson((String)splits.apply(0)).asJsonObject();
            JsonObject payload = package$.MODULE$.decodeJson((String)splits.apply(1)).asJsonObject();
            String encodedHeader = package$.MODULE$.encodeJson((JsonStructure)header);
            String encodedPayload = package$.MODULE$.encodeJson((JsonStructure)payload);
            String signingInput = new StringBuilder(1).append(encodedHeader).append(".").append(encodedPayload).toString();
            Tuple2<String, Key> tuple2 = this.signingKey();
            if (tuple2 != null) {
                Key key = (Key)tuple2._2();
                Key key2 = key;
                if (!(key2 instanceof SecretKey)) {
                    throw new MatchError((Object)key2);
                }
                SecretKey secretKey = (SecretKey)key2;
                string = new StringBuilder(1).append(signingInput).append(".").append(new String(package$.MODULE$.encodeBytes(this.hmac(secretKey, signingInput)), StandardCharsets.UTF_8)).toString();
            } else {
                throw new MatchError(tuple2);
            }
            String string2 = string;
            String signature = string2;
            tracer.out().printfIndentln("signature = %s", new Object[]{signature});
            return BoxesRunTime.equals((Object)ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.refArrayOps((Object[])signature.split("\\."))).apply(2), (Object)splits.apply(2));
        }));
    }

    public JsonWebSignature(String kid) {
        this.kid = kid;
        Tracing.$init$(this);
        this.signingKey = this.retrieveSigningKey();
        this.algoMap = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"HmacSHA256"), (Object)"HS256"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SHA256withECDSA"), (Object)"ES256")}));
    }
}

