/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.scala.jws;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.scala.diagnosis.Tracing;
import de.christofreichardt.scala.jws.package$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;
import javax.crypto.SecretKey;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import scala.Function0;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005)4Qa\u0004\t\u0002\u0002eA\u0001\"\n\u0001\u0003\u0006\u0004%\tA\n\u0005\te\u0001\u0011\t\u0011)A\u0005O!)1\u0007\u0001C\u0001i!9\u0001\b\u0001b\u0001\n\u0003I\u0004BB#\u0001A\u0003%!\bC\u0004G\u0001\t\u0007I\u0011A$\t\rU\u0003\u0001\u0015!\u0003I\u0011\u001d1\u0006A1A\u0005\u0002]Ca\u0001\u0019\u0001!\u0002\u0013A\u0006bB1\u0001\u0005\u0004%\tA\n\u0005\u0007E\u0002\u0001\u000b\u0011B\u0014\t\u000b\r\u0004a\u0011\u00013\t\u000b\u0015\u0004A\u0011A,\t\u000b\u0019\u0004A\u0011A4\u0003\u0013);6kU5h]\u0016\u0014(BA\t\u0013\u0003\rQwo\u001d\u0006\u0003'Q\tQa]2bY\u0006T!!\u0006\f\u0002#\rD'/[:u_\u001a\u0014X-[2iCJ$GOC\u0001\u0018\u0003\t!Wm\u0001\u0001\u0014\u0007\u0001Qr\u0004\u0005\u0002\u001c;5\tADC\u0001\u0014\u0013\tqBD\u0001\u0004B]f\u0014VM\u001a\t\u0003A\rj\u0011!\t\u0006\u0003EI\t\u0011\u0002Z5bO:|7/[:\n\u0005\u0011\n#a\u0002+sC\u000eLgnZ\u0001\u0004W&$W#A\u0014\u0011\u0005!zcBA\u0015.!\tQC$D\u0001,\u0015\ta\u0003$\u0001\u0004=e>|GOP\u0005\u0003]q\ta\u0001\u0015:fI\u00164\u0017B\u0001\u00192\u0005\u0019\u0019FO]5oO*\u0011a\u0006H\u0001\u0005W&$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003k]\u0002\"A\u000e\u0001\u000e\u0003AAQ!J\u0002A\u0002\u001d\n!b]5h]&twmS3z+\u0005Q\u0004\u0003B\u000e<OuJ!\u0001\u0010\u000f\u0003\rQ+\b\u000f\\33!\tq4)D\u0001@\u0015\t\u0001\u0015)\u0001\u0005tK\u000e,(/\u001b;z\u0015\u0005\u0011\u0015\u0001\u00026bm\u0006L!\u0001R \u0003\u0007-+\u00170A\u0006tS\u001et\u0017N\\4LKf\u0004\u0013aB1mO>l\u0015\r]\u000b\u0002\u0011B!\u0011J\u0014)Q\u001b\u0005Q%BA&M\u0003%IW.\\;uC\ndWM\u0003\u0002N9\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005=S%aA'baB\u0011\u0011\u000bV\u0007\u0002%*\u00111+Q\u0001\u0005Y\u0006tw-\u0003\u00021%\u0006A\u0011\r\\4p\u001b\u0006\u0004\b%\u0001\u0004iK\u0006$WM]\u000b\u00021B\u0011\u0011LX\u0007\u00025*\u00111\fX\u0001\u0005UN|gNC\u0001^\u0003\u0015Q\u0017M^1y\u0013\ty&L\u0001\u0006Kg>twJ\u00196fGR\fq\u0001[3bI\u0016\u0014\b%A\u0007f]\u000e|G-\u001a3IK\u0006$WM]\u0001\u000fK:\u001cw\u000eZ3e\u0011\u0016\fG-\u001a:!\u0003I\u0011X\r\u001e:jKZ,7+[4oS:<7*Z=\u0015\u0003i\n1BY;jY\u0012DU-\u00193fe\u0006!1/[4o)\t9\u0003\u000eC\u0003j\u001d\u0001\u0007\u0001,A\u0004qCfdw.\u00193")
public abstract class JWSSigner
implements Tracing {
    private final String kid;
    private final Tuple2<String, Key> signingKey;
    private final Map<String, String> algoMap;
    private final JsonObject header;
    private final String encodedHeader;

    @Override
    public <T> T withTracer(String resultTypeAsString, Object callee, String methodSignature, Function0<T> block) {
        return (T)Tracing.withTracer$(this, resultTypeAsString, callee, methodSignature, block);
    }

    @Override
    public AbstractTracer getCurrentTracer() {
        return Tracing.getCurrentTracer$(this);
    }

    public String kid() {
        return this.kid;
    }

    public Tuple2<String, Key> signingKey() {
        return this.signingKey;
    }

    public Map<String, String> algoMap() {
        return this.algoMap;
    }

    public JsonObject header() {
        return this.header;
    }

    public String encodedHeader() {
        return this.encodedHeader;
    }

    public abstract Tuple2<String, Key> retrieveSigningKey();

    public JsonObject buildHeader() {
        return (JsonObject)this.withTracer("JsonObject", this, "buildHeader()", (Function0 & Serializable)() -> {
            AbstractTracer tracer = this.getCurrentTracer();
            tracer.out().printfIndentln("signingKey = (%s,%s(%s))", new Object[]{this.signingKey()._1(), ((Key)this.signingKey()._2()).getAlgorithm(), de.christofreichardt.scala.package$.MODULE$.formatBytes((Iterable<Object>)Predef$.MODULE$.wrapByteArray(((Key)this.signingKey()._2()).getEncoded()))});
            Tuple2<String, Key> tuple2 = this.signingKey();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Key key = (Key)tuple2._2();
            JsonObject jsonObject = Json.createObjectBuilder().add("typ", "json").add("alg", (String)this.algoMap().apply((Object)key.getAlgorithm())).build();
            return jsonObject;
        });
    }

    public String sign(JsonObject payload) {
        return (String)this.withTracer("String", this, "sign(payload: JsonObject)", (Function0 & Serializable)() -> {
            String string;
            AbstractTracer tracer = this.getCurrentTracer();
            tracer.out().printfIndentln("payload = %s", new Object[]{payload});
            String encodedPayload = package$.MODULE$.encodeJson((JsonStructure)payload);
            String signingInput = new StringBuilder(1).append(this.encodedHeader()).append(".").append(encodedPayload).toString();
            Tuple2<String, Key> tuple2 = this.signingKey();
            if (tuple2 == null) throw new MatchError(tuple2);
            Key key = (Key)tuple2._2();
            Key key2 = key;
            if (key2 instanceof SecretKey) {
                SecretKey secretKey = (SecretKey)key2;
                string = new StringBuilder(1).append(signingInput).append(".").append(new String(package$.MODULE$.encodeBytes(package$.MODULE$.hmac(secretKey, signingInput)), StandardCharsets.UTF_8)).toString();
                return string;
            } else {
                if (!(key2 instanceof PrivateKey)) throw new MatchError((Object)key2);
                PrivateKey privateKey = (PrivateKey)key2;
                JWSSigner.trace$1(privateKey, tracer);
                Signature signatureAlgo = Signature.getInstance("SHA512withECDSA");
                signatureAlgo.initSign(privateKey);
                signatureAlgo.update(signingInput.getBytes(StandardCharsets.UTF_8));
                string = new StringBuilder(1).append(signingInput).append(".").append(new String(package$.MODULE$.encodeBytes(signatureAlgo.sign()), StandardCharsets.UTF_8)).toString();
            }
            return string;
        });
    }

    private static final void trace$1(PrivateKey key, AbstractTracer tracer$1) {
        PrivateKey privateKey = key;
        if (privateKey instanceof ECPrivateKey) {
            ECPrivateKey eCPrivateKey = (ECPrivateKey)privateKey;
            ECParameterSpec ecParameterSpec = eCPrivateKey.getParams();
            EllipticCurve curve = ecParameterSpec.getCurve();
            ECField field = curve.getField();
            ECField eCField = field;
            if (!(eCField instanceof ECFieldFp)) {
                throw new MatchError((Object)eCField);
            }
            ECFieldFp eCFieldFp = (ECFieldFp)eCField;
            tracer$1.out().printfIndentln("ecParameterSpec = ECParameterSpec[curve=EllipticCurve[a=%s, b=%s, field=ECFieldFp[p=%s, size=%s]], cofactor=%d, generator=%s, order=%s]", new Object[]{curve.getA(), curve.getB(), eCFieldFp.getP(), Predef$.MODULE$.int2Integer(eCFieldFp.getFieldSize()), Predef$.MODULE$.int2Integer(ecParameterSpec.getCofactor()), ecParameterSpec.getGenerator(), ecParameterSpec.getOrder()});
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)privateKey);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public JWSSigner(String kid) {
        this.kid = kid;
        Tracing.$init$(this);
        this.signingKey = this.retrieveSigningKey();
        this.algoMap = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"HmacSHA256"), (Object)"HS256"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"EC"), (Object)"ES512")}));
        this.header = this.buildHeader();
        this.encodedHeader = package$.MODULE$.encodeJson((JsonStructure)this.header());
    }
}

