/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.jca.shamir;

import de.christofreichardt.jca.shamir.ShamirsProtection;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.util.Optional;

public class ShamirsLoadParameter
implements KeyStore.LoadStoreParameter {
    final ShamirsProtection shamirsProtection;
    final File file;
    final String name;
    final InputStream inputStream;
    final OutputStream outputStream;

    public ShamirsLoadParameter(File file, ShamirsProtection shamirsProtection) {
        this.shamirsProtection = shamirsProtection;
        this.file = file;
        this.name = this.file.getName();
        this.inputStream = null;
        this.outputStream = null;
    }

    public ShamirsLoadParameter(InputStream inputStream, ShamirsProtection shamirsProtection) {
        this.shamirsProtection = shamirsProtection;
        this.inputStream = inputStream;
        this.name = String.valueOf(this.inputStream.hashCode());
        this.file = null;
        this.outputStream = null;
    }

    public ShamirsLoadParameter(OutputStream outputStream, ShamirsProtection shamirsProtection) {
        this.shamirsProtection = shamirsProtection;
        this.outputStream = outputStream;
        this.file = null;
        this.inputStream = null;
        this.name = String.valueOf(this.outputStream.hashCode());
    }

    @Override
    public KeyStore.ProtectionParameter getProtectionParameter() {
        return this.shamirsProtection;
    }

    public Optional<File> getFile() {
        return Optional.ofNullable(this.file);
    }

    public String getName() {
        return this.name;
    }

    public Optional<InputStream> getInputStream() {
        return Optional.ofNullable(this.inputStream);
    }

    public Optional<OutputStream> getOutputStream() {
        return Optional.ofNullable(this.outputStream);
    }
}

