/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.jca.shamir;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.Traceable;
import de.christofreichardt.diagnosis.TracerFactory;
import de.christofreichardt.jca.shamir.ShamirsLoadParameter;
import de.christofreichardt.jca.shamir.ShamirsProtection;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;

public class ShamirsKeystore
extends KeyStoreSpi
implements Traceable {
    private KeyStore keyStore;

    public ShamirsKeystore() {
        try {
            this.keyStore = KeyStore.getInstance("pkcs12");
        }
        catch (KeyStoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        try {
            return this.keyStore.getKey(alias, password);
        }
        catch (KeyStoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        try {
            return this.keyStore.getCertificateChain(alias);
        }
        catch (KeyStoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        try {
            return this.keyStore.getCertificate(alias);
        }
        catch (KeyStoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        try {
            return this.keyStore.getCreationDate(alias);
        }
        catch (KeyStoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        this.keyStore.setKeyEntry(alias, key, password, chain);
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        this.keyStore.setKeyEntry(alias, key, chain);
    }

    @Override
    public KeyStore.Entry engineGetEntry(String alias, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        KeyStore.Entry entry;
        if (!this.keyStore.isCertificateEntry(alias)) {
            if (!(protectionParameter instanceof ShamirsProtection)) {
                throw new IllegalArgumentException("ShamirsProtection required.");
            }
            ShamirsProtection shamirsProtection = (ShamirsProtection)protectionParameter;
            KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(shamirsProtection.getPassword());
            entry = this.keyStore.getEntry(alias, passwordProtection);
        } else {
            entry = this.keyStore.getEntry(alias, null);
        }
        return entry;
    }

    @Override
    public void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException {
        if (!(protectionParameter instanceof ShamirsProtection)) {
            throw new IllegalArgumentException("ShamirsProtection required.");
        }
        ShamirsProtection shamirsProtection = (ShamirsProtection)protectionParameter;
        KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(shamirsProtection.getPassword());
        this.keyStore.setEntry(alias, entry, passwordProtection);
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        this.keyStore.setCertificateEntry(alias, cert);
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        this.keyStore.deleteEntry(alias);
    }

    @Override
    public Enumeration<String> engineAliases() {
        try {
            return this.keyStore.aliases();
        }
        catch (KeyStoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        try {
            return this.keyStore.containsAlias(alias);
        }
        catch (KeyStoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public int engineSize() {
        try {
            return this.keyStore.size();
        }
        catch (KeyStoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        try {
            return this.keyStore.isKeyEntry(alias);
        }
        catch (KeyStoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        try {
            return this.keyStore.isCertificateEntry(alias);
        }
        catch (KeyStoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        try {
            return this.keyStore.getCertificateAlias(cert);
        }
        catch (KeyStoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        try {
            this.keyStore.store(stream, password);
        }
        catch (KeyStoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void engineStore(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (!(loadStoreParameter instanceof ShamirsLoadParameter)) {
            throw new IllegalArgumentException("ShamirsLoadParameter required.");
        }
        ShamirsLoadParameter shamirsLoadParameter = (ShamirsLoadParameter)loadStoreParameter;
        ShamirsProtection shamirsProtection = (ShamirsProtection)shamirsLoadParameter.getProtectionParameter();
        if (shamirsLoadParameter.getFile().isPresent()) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(shamirsLoadParameter.getFile().get());){
                this.engineStore(fileOutputStream, shamirsProtection.getPassword());
            }
        } else {
            OutputStream outputStream = shamirsLoadParameter.getOutputStream().orElseThrow(() -> new IOException("Missing OutputStream."));
            this.engineStore(outputStream, shamirsProtection.getPassword());
        }
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.keyStore.load(stream, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineLoad(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
        block10: {
            AbstractTracer tracer = this.getCurrentTracer();
            tracer.entry("void", (Object)this, "engineLoad(LoadStoreParameter loadStoreParameter)");
            try {
                if (!(loadStoreParameter instanceof ShamirsLoadParameter)) {
                    throw new IllegalArgumentException("Need ShamirsLoadParameter.");
                }
                ShamirsLoadParameter shamirsLoadParameter = (ShamirsLoadParameter)loadStoreParameter;
                ShamirsProtection shamirsProtection = (ShamirsProtection)shamirsLoadParameter.getProtectionParameter();
                if (shamirsLoadParameter.getFile().isPresent()) {
                    try (FileInputStream fileInputStream = new FileInputStream(shamirsLoadParameter.getFile().get());){
                        this.engineLoad(fileInputStream, shamirsProtection.getPassword());
                        break block10;
                    }
                }
                InputStream inputStream = shamirsLoadParameter.getInputStream().orElseThrow(() -> new IOException("Missing InputStream."));
                this.engineLoad(inputStream, shamirsProtection.getPassword());
            }
            finally {
                tracer.wayout();
            }
        }
    }

    @Override
    public boolean engineEntryInstanceOf(String alias, Class<? extends KeyStore.Entry> entryClass) {
        try {
            return this.keyStore.entryInstanceOf(alias, entryClass);
        }
        catch (KeyStoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    public AbstractTracer getCurrentTracer() {
        return TracerFactory.getInstance().getDefaultTracer();
    }
}

