/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.jca.shamir;

import de.christofreichardt.jca.shamir.ShamirsKeystore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.ProviderException;

public final class ShamirsProvider
extends Provider {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "Christofs Crypto Lib";

    public ShamirsProvider() {
        super(NAME, "0.0.1", "A pkcs12 KeyStore implementation which supports shared passwords.");
        this.put("KeyStore.ShamirsKeystore", "de.christofreichardt.jca.shamir.ShamirsKeystore");
    }

    private static final class ProviderService
    extends Provider.Service {
        public ProviderService(Provider provider, String type, String algorithm, String className) {
            super(provider, type, algorithm, className, null, null);
        }

        @Override
        public Object newInstance(Object constructorParameter) throws NoSuchAlgorithmException {
            String type = this.getType();
            String algo = this.getAlgorithm();
            try {
                if (type.equals("KeyStore") && algo.equals("ShamirsKeystore")) {
                    return new ShamirsKeystore();
                }
            }
            catch (Exception ex) {
                throw new NoSuchAlgorithmException("Error constructing " + type + " for " + algo + " using Christofs Crypto Lib", ex);
            }
            throw new ProviderException("No impl for " + algo + " " + type);
        }
    }
}

