/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.jca.shamir;

import de.christofreichardt.scala.shamir.SecretMerging;
import java.nio.file.Path;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Collection;
import javax.json.JsonArray;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

public class ShamirsProtection
implements KeyStore.ProtectionParameter,
Destroyable {
    private final char[] password;
    private boolean destroyed = false;

    public ShamirsProtection(Path[] paths) {
        this.password = this.mergePassword(paths);
    }

    public ShamirsProtection(Collection<Path> paths) {
        this(paths.toArray(new Path[0]));
    }

    public ShamirsProtection(JsonArray slices) {
        this.password = this.mergePassword(slices);
    }

    private char[] mergePassword(Path[] paths) {
        return SecretMerging.apply((Path[])paths).password();
    }

    private char[] mergePassword(JsonArray slices) {
        return SecretMerging.apply((JsonArray)slices).password();
    }

    public char[] getPassword() {
        if (this.destroyed) {
            throw new IllegalStateException("Password has been cleared.");
        }
        return this.password;
    }

    @Override
    public void destroy() throws DestroyFailedException {
        this.destroyed = true;
        if (this.password != null) {
            Arrays.fill(this.password, ' ');
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }
}

