/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.jca.shamir;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.NullTracer;
import de.christofreichardt.diagnosis.Traceable;
import de.christofreichardt.diagnosis.TracerFactory;
import java.security.DrbgParameters;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class PasswordGenerator
implements Traceable {
    private static final char[] ALPHANUMERIC = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
    private static final char[] UMLAUTS = new char[]{'\u00c4', '\u00d6', '\u00dc', '\u00e4', '\u00f6', '\u00fc'};
    private static final char[] PUNCTUATION_AND_SYMBOLS = new char[]{'!', '#', '$', '%', '&', '(', ')', '*', '+', '-', '<', '=', '>', '?'};
    private static final char[] ALPHANUMERIC_WITH_UMLAUTS = ArrayUtils.concat(ALPHANUMERIC, UMLAUTS);
    private static final char[] ALPHANUMERIC_WITH_PUNCTUATION_AND_SYMBOLS = ArrayUtils.concat(ALPHANUMERIC, PUNCTUATION_AND_SYMBOLS);
    private static final char[] ALL = ArrayUtils.concat(ALPHANUMERIC_WITH_PUNCTUATION_AND_SYMBOLS, UMLAUTS);
    final SecureRandom secureRandom = SecureRandom.getInstance("DRBG", DrbgParameters.instantiation(256, DrbgParameters.Capability.PR_AND_RESEED, "christof".getBytes()));
    final int length;
    final char[] symbols;

    public static char[] alphanumeric() {
        return Arrays.copyOf(ALPHANUMERIC, ALPHANUMERIC.length);
    }

    public static char[] umlauts() {
        return Arrays.copyOf(UMLAUTS, UMLAUTS.length);
    }

    public static char[] punctuationAndSymbols() {
        return Arrays.copyOf(PUNCTUATION_AND_SYMBOLS, PUNCTUATION_AND_SYMBOLS.length);
    }

    public static char[] alphanumericWithUmlauts() {
        return Arrays.copyOf(ALPHANUMERIC_WITH_UMLAUTS, ALPHANUMERIC_WITH_UMLAUTS.length);
    }

    public static char[] alphanumericWithPunctuationAndSymbols() {
        return Arrays.copyOf(ALPHANUMERIC_WITH_PUNCTUATION_AND_SYMBOLS, ALPHANUMERIC_WITH_PUNCTUATION_AND_SYMBOLS.length);
    }

    public static char[] all() {
        return Arrays.copyOf(ALL, ALL.length);
    }

    public PasswordGenerator(int length) throws GeneralSecurityException {
        this(length, ALPHANUMERIC);
    }

    public PasswordGenerator(int length, char[] symbols) throws GeneralSecurityException {
        this.length = length;
        this.symbols = Arrays.copyOf(symbols, symbols.length);
    }

    public Stream<CharSequence> generate() {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("Stream<CharSequence>", (Object)this, "generate()");
        try {
            Stream<CharSequence> stream = Stream.generate(() -> this.password());
            return stream;
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<CharSequence> generate(char[] requiredChars) {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("Stream<CharSequence>", (Object)this, "generate(char[] requiredChars)");
        try {
            tracer.out().printfIndentln("requiredChars = %s", new Object[]{Arrays.toString(requiredChars)});
            HashSet<char[]> requiredCharacterSet = new HashSet<char[]>();
            requiredCharacterSet.add(requiredChars);
            Stream<CharSequence> stream = this.generate(requiredCharacterSet);
            return stream;
        }
        finally {
            tracer.wayout();
        }
    }

    private boolean matchRequiredCharSet(char[] requiredCharSet) {
        IntStream.Builder builder = IntStream.builder();
        for (char c2 : requiredCharSet) {
            builder.add(c2);
        }
        boolean allFound = builder.build().allMatch(c -> {
            boolean found = false;
            for (char symbol : this.symbols) {
                boolean bl = found = c == symbol;
                if (found) break;
            }
            return found;
        });
        return allFound;
    }

    private boolean requiredCharacterFound(CharSequence passwordSeq, Set<char[]> requiredCharSets) {
        return requiredCharSets.stream().allMatch(requiredCharSet -> {
            boolean matched = false;
            for (char c : requiredCharSet) {
                matched = passwordSeq.chars().anyMatch(passwordChar -> c == passwordChar);
                if (matched) break;
            }
            return matched;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<CharSequence> generate(Set<char[]> requiredCharSets) {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("Stream<CharSequence>", (Object)this, "generate(char[] requiredChars)");
        try {
            requiredCharSets.forEach(requiredCharSet -> tracer.out().printfIndentln("requiredChars = %s", new Object[]{Arrays.toString(requiredCharSet)}));
            boolean allRequiredCharsetsMatched = requiredCharSets.stream().allMatch(requiredCharSet -> this.matchRequiredCharSet((char[])requiredCharSet));
            if (!allRequiredCharsetsMatched) {
                throw new IllegalArgumentException("Required character not present within given symbol set.");
            }
            Stream<CharSequence> stream = Stream.generate(() -> this.password()).filter(password -> this.requiredCharacterFound((CharSequence)password, requiredCharSets));
            return stream;
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharSequence password() {
        NullTracer tracer = TracerFactory.getInstance().getDefaultTracer();
        tracer.entry("CharSequence", (Object)this, "password()");
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.length; ++i) {
                int index = this.secureRandom.nextInt(this.symbols.length);
                stringBuilder.append(this.symbols[index]);
            }
            StringBuilder stringBuilder2 = stringBuilder;
            return stringBuilder2;
        }
        finally {
            tracer.wayout();
        }
    }

    public AbstractTracer getCurrentTracer() {
        return TracerFactory.getInstance().getCurrentPoolTracer();
    }

    public static class ArrayUtils {
        public static char[] concat(char[] a1, char[] a2) {
            char[] result = new char[a1.length + a2.length];
            System.arraycopy(a1, 0, result, 0, a1.length);
            System.arraycopy(a2, 0, result, a1.length, a2.length);
            return result;
        }
    }
}

