/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.json.websignature;

import de.christofreichardt.asn1.ASN1IntSequence;
import de.christofreichardt.asn1.ASN1Integer;
import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.TracerFactory;
import de.christofreichardt.json.webkey.JsonWebKey;
import de.christofreichardt.json.webkey.JsonWebKeyUtils;
import de.christofreichardt.json.websignature.JWSAlgorithm;
import de.christofreichardt.json.websignature.JWSBase;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.util.HexFormat;
import java.util.Objects;

public class SHA512WithECDSA
implements JWSAlgorithm {
    final Signature signature = Signature.getInstance("SHA512withECDSA");

    SHA512WithECDSA() throws NoSuchAlgorithmException {
    }

    @Override
    public void init(Key key) throws GeneralSecurityException {
        this.validateCurveParameter(key);
        if (key instanceof ECPrivateKey) {
            ECPrivateKey privateKey = (ECPrivateKey)key;
            this.signature.initSign(privateKey);
        } else if (key instanceof ECPublicKey) {
            ECPublicKey publicKey = (ECPublicKey)key;
            this.signature.initVerify(publicKey);
        }
    }

    void validateCurveParameter(Key key) throws InvalidKeyException {
        if (!(key instanceof ECKey)) {
            throw new InvalidKeyException();
        }
        ECKey ecKey = (ECKey)((Object)key);
        ECParameterSpec ecParameterSpec = JsonWebKey.EC_PARAMETER_SPEC_MAP.get("secp521r1");
        ECField eCField = ecParameterSpec.getCurve().getField();
        if (!(eCField instanceof ECFieldFp)) {
            throw new AssertionError();
        }
        ECFieldFp ecFieldFp1 = (ECFieldFp)eCField;
        BigInteger prime = ecFieldFp1.getP();
        ECField eCField2 = ecKey.getParams().getCurve().getField();
        if (!(eCField2 instanceof ECFieldFp)) {
            throw new InvalidKeyException();
        }
        ECFieldFp ecFieldFp2 = (ECFieldFp)eCField2;
        if (!Objects.equals(ecFieldFp2.getP(), prime)) {
            throw new InvalidKeyException();
        }
        if (ecFieldFp2.getFieldSize() != 521) {
            throw new InvalidKeyException();
        }
        if (!Objects.equals(ecKey.getParams().getCurve().getA(), ecParameterSpec.getCurve().getA())) {
            throw new InvalidKeyException();
        }
        if (!Objects.equals(ecKey.getParams().getCurve().getB(), ecParameterSpec.getCurve().getB())) {
            throw new InvalidKeyException();
        }
        if (!Objects.equals(ecKey.getParams().getGenerator().getAffineX(), ecParameterSpec.getGenerator().getAffineX())) {
            throw new InvalidKeyException();
        }
        if (!Objects.equals(ecKey.getParams().getGenerator().getAffineY(), ecParameterSpec.getGenerator().getAffineY())) {
            throw new InvalidKeyException();
        }
        if (!Objects.equals(ecKey.getParams().getOrder(), ecParameterSpec.getOrder())) {
            throw new InvalidKeyException();
        }
    }

    @Override
    public void update(byte[] data) throws GeneralSecurityException {
        this.signature.update(data);
    }

    @Override
    public byte[] signature() throws GeneralSecurityException {
        return this.signature.sign();
    }

    @Override
    public boolean verify(byte[] signature) throws GeneralSecurityException {
        return this.signature.verify(signature);
    }

    @Override
    public String algorithm() {
        return this.signature.getAlgorithm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String postSigning(byte[] signature) {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("String", (Object)this, "postSigning(byte[] signature)");
        try {
            tracer.out().printfIndentln("signature.length = %d, signature = %s", new Object[]{signature.length, HexFormat.ofDelimiter(" ").formatHex(signature)});
            ASN1IntSequence asn1IntSequence = new ASN1IntSequence(signature);
            ASN1IntSequence.Iterator iter = asn1IntSequence.iterator();
            ASN1Integer asn1_r = iter.next();
            if (!asn1_r.isShortForm()) {
                throw new IllegalArgumentException("Short form of length octets required.");
            }
            ASN1Integer asn1_s = iter.next();
            if (!asn1_s.isShortForm()) {
                throw new IllegalArgumentException("Short form of length octets required.");
            }
            if (iter.hasNext()) {
                throw new IllegalArgumentException("Only two integers expected.");
            }
            byte[] r = JsonWebKeyUtils.alignBytes(asn1_r.actualBytes(), 66);
            byte[] s = JsonWebKeyUtils.alignBytes(asn1_s.actualBytes(), 66);
            signature = new byte[132];
            System.arraycopy(r, 0, signature, 0, 66);
            System.arraycopy(s, 0, signature, 66, 66);
            String string = JWSBase.encode(signature);
            return string;
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] preValidating(byte[] signature) {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("byte[]", (Object)this, "preValidating(byte[] signature)");
        try {
            HexFormat hexFormat = HexFormat.ofDelimiter(" ");
            tracer.out().printfIndentln("signature.length = %d, signature = %s", new Object[]{signature.length, hexFormat.formatHex(signature)});
            if (signature.length != 132) {
                throw new IllegalArgumentException("Expected exactly 132 octets.");
            }
            byte[] r = new byte[66];
            System.arraycopy(signature, 0, r, 0, 66);
            r = JsonWebKeyUtils.skipLeadingZeroes(r);
            byte[] s = new byte[66];
            System.arraycopy(signature, 66, s, 0, 66);
            s = JsonWebKeyUtils.skipLeadingZeroes(s);
            ASN1Integer asn1_r = ASN1Integer.encode(r);
            ASN1Integer asn1_s = ASN1Integer.encode(s);
            ASN1IntSequence asn1Signature = ASN1IntSequence.fromASN1Integers(asn1_r, asn1_s);
            byte[] byArray = asn1Signature.encoded();
            return byArray;
        }
        finally {
            tracer.wayout();
        }
    }

    public AbstractTracer getCurrentTracer() {
        return TracerFactory.getInstance().getDefaultTracer();
    }
}

