/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.json.websignature;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.TracerFactory;
import de.christofreichardt.json.websignature.JWSAlgorithm;
import de.christofreichardt.json.websignature.JWSBase;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class SHA256withRSA
implements JWSAlgorithm {
    final Signature signature = Signature.getInstance("SHA256withRSA");

    SHA256withRSA() throws NoSuchAlgorithmException {
    }

    @Override
    public void init(Key key) throws GeneralSecurityException {
        if (key instanceof RSAPrivateKey) {
            RSAPrivateKey privateKey = (RSAPrivateKey)key;
            this.signature.initSign(privateKey);
        } else if (key instanceof RSAPublicKey) {
            RSAPublicKey publicKey = (RSAPublicKey)key;
            this.signature.initVerify(publicKey);
        } else {
            throw new InvalidKeyException();
        }
    }

    @Override
    public void update(byte[] data) throws SignatureException {
        this.signature.update(data);
    }

    @Override
    public byte[] signature() throws SignatureException {
        return this.signature.sign();
    }

    @Override
    public boolean verify(byte[] signature) throws SignatureException {
        return this.signature.verify(signature);
    }

    @Override
    public String algorithm() {
        return this.signature.getAlgorithm();
    }

    @Override
    public String postSigning(byte[] signature) {
        return JWSBase.encode(signature);
    }

    @Override
    public byte[] preValidating(byte[] signature) {
        return signature;
    }

    public AbstractTracer getCurrentTracer() {
        return TracerFactory.getInstance().getDefaultTracer();
    }
}

