/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.json.websignature;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.Traceable;
import de.christofreichardt.diagnosis.TracerFactory;
import de.christofreichardt.json.websignature.JWSBase;
import de.christofreichardt.json.websignature.JWSCompactSerialization;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;

public class JWSValidator
extends JWSBase
implements Traceable {
    final byte[] signatureOctets;

    public JWSValidator(JWSCompactSerialization compactSerialization) {
        super(compactSerialization.makeJWSStruct());
        this.signatureOctets = JWSValidator.decode(compactSerialization.encodedSignature().getBytes(StandardCharsets.ISO_8859_1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(Key key) throws GeneralSecurityException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("boolean", (Object)this, "validate(Key signingKey)");
        try {
            String encodedHeader = JWSValidator.encode(this.jwsStruct.strJoseHeader());
            String encodedPayload = JWSValidator.encode(this.jwsStruct.strPayload());
            this.jwa.init(key);
            String signingInput = String.format("%s.%s", encodedHeader, encodedPayload);
            byte[] signingInputOctets = signingInput.getBytes(StandardCharsets.US_ASCII);
            this.jwa.update(signingInputOctets);
            boolean bl = this.jwa.verify(this.jwa.preValidating(this.signatureOctets));
            return bl;
        }
        finally {
            tracer.wayout();
        }
    }

    public AbstractTracer getCurrentTracer() {
        return TracerFactory.getInstance().getDefaultTracer();
    }
}

