/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.json.websignature;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.Traceable;
import de.christofreichardt.diagnosis.TracerFactory;
import de.christofreichardt.json.websignature.JWSBase;
import de.christofreichardt.json.websignature.JWSCompactSerialization;
import de.christofreichardt.json.websignature.Json2StringConverter;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;

public class JWSSigner
extends JWSBase
implements Traceable {
    public JWSSigner(JsonObject joseHeader, JsonStructure payload) {
        this(joseHeader, payload, JsonValue::toString);
    }

    public JWSSigner(JsonObject joseHeader, JsonStructure payload, Json2StringConverter converter) {
        super(new JWSBase.JWSStruct(joseHeader, converter.convert((JsonStructure)joseHeader), payload, converter.convert(payload)));
    }

    public JWSSigner(String strJoseHeader, String strPayload) {
        super(new JWSBase.JWSStruct(JWSSigner.read(strJoseHeader).asJsonObject(), strJoseHeader, JWSSigner.read(strPayload), strPayload));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JWSCompactSerialization sign(Key signingKey) throws GeneralSecurityException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("String", (Object)this, "sign(String strPayload, Key signingKey)");
        try {
            String encodedHeader = JWSSigner.encode(this.jwsStruct.strJoseHeader());
            String encodedPayload = JWSSigner.encode(this.jwsStruct.strPayload());
            this.jwa.init(signingKey);
            String signingInput = String.format("%s.%s", encodedHeader, encodedPayload);
            byte[] signingInputOctets = signingInput.getBytes(StandardCharsets.US_ASCII);
            this.jwa.update(signingInputOctets);
            byte[] signatureOctets = this.jwa.signature();
            String encodedSignature = this.jwa.postSigning(signatureOctets);
            JWSCompactSerialization jWSCompactSerialization = new JWSCompactSerialization(encodedHeader, encodedPayload, encodedSignature);
            return jWSCompactSerialization;
        }
        finally {
            tracer.wayout();
        }
    }

    public AbstractTracer getCurrentTracer() {
        return TracerFactory.getInstance().getDefaultTracer();
    }
}

