/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.json.websignature;

import de.christofreichardt.json.websignature.JWSBase;
import jakarta.json.JsonObject;

public record JWSCompactSerialization(String encodedHeader, String encodedPayload, String encodedSignature) {
    public static JWSCompactSerialization of(String compactSerialization) {
        String[] splits = compactSerialization.split("\\.");
        if (splits.length != 3) {
            throw new IllegalArgumentException("Not a compact serialization.");
        }
        return new JWSCompactSerialization(splits[0], splits[1], splits[2]);
    }

    JWSBase.JWSStruct makeJWSStruct() {
        String strJoseHeader = JWSBase.decode(this.encodedHeader);
        String strJWSPayload = JWSBase.decode(this.encodedPayload);
        return new JWSBase.JWSStruct(JWSBase.read(strJoseHeader).asJsonObject(), strJoseHeader, JWSBase.read(strJWSPayload), strJWSPayload);
    }

    public JsonObject joseHeader() {
        return JWSBase.read(JWSBase.decode(this.encodedHeader)).asJsonObject();
    }

    public JsonObject payload() {
        return JWSBase.read(JWSBase.decode(this.encodedPayload)).asJsonObject();
    }

    public String strJoseHeader() {
        return JWSBase.decode(this.encodedHeader);
    }

    public String strPayload() {
        return JWSBase.decode(this.encodedPayload);
    }

    @Override
    public String toString() {
        return String.format("%s.%s.%s", this.encodedHeader, this.encodedPayload, this.encodedSignature);
    }
}

