/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.json.websignature;

import de.christofreichardt.json.JsonUtils;
import de.christofreichardt.json.websignature.HmacSHA256;
import de.christofreichardt.json.websignature.JWSAlgorithm;
import de.christofreichardt.json.websignature.SHA256withECDSA;
import de.christofreichardt.json.websignature.SHA256withRSA;
import de.christofreichardt.json.websignature.SHA512WithECDSA;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;

public abstract class JWSBase {
    static final Base64.Encoder BASE64_URL_ENCODER = Base64.getUrlEncoder().withoutPadding();
    static final Base64.Decoder BASE64_URL_DECODER = Base64.getUrlDecoder();
    static final Map<String, Class<? extends JWSAlgorithm>> ALGO_MAP = Map.of("HS256", HmacSHA256.class, "RS256", SHA256withRSA.class, "ES256", SHA256withECDSA.class, "ES512", SHA512WithECDSA.class);
    final JWSStruct jwsStruct;
    final JWSAlgorithm jwa;

    public static String encode(String input) {
        return BASE64_URL_ENCODER.encodeToString(input.getBytes(StandardCharsets.UTF_8));
    }

    public static String encode(byte[] input) {
        return BASE64_URL_ENCODER.encodeToString(input);
    }

    static String decode(String input) {
        return new String(BASE64_URL_DECODER.decode(input), StandardCharsets.UTF_8);
    }

    static byte[] decode(byte[] input) {
        return BASE64_URL_DECODER.decode(input);
    }

    public static byte[] decodeToBytes(String input) {
        return BASE64_URL_DECODER.decode(input);
    }

    static JsonStructure read(String input) {
        try (JsonReader jsonReader = Json.createReader((Reader)new StringReader(input));){
            JsonStructure jsonStructure = jsonReader.read();
            return jsonStructure;
        }
    }

    JWSBase(JWSStruct jwsStruct) {
        this.jwsStruct = jwsStruct;
        this.jwa = this.jwsStruct.algorithm();
    }

    public String getStrJoseHeader() {
        return this.jwsStruct.strJoseHeader();
    }

    public JsonObject getJoseHeader() {
        return this.jwsStruct.joseHeader();
    }

    public String getStrPayload() {
        return this.jwsStruct.strPayload();
    }

    public JsonStructure getPayload() {
        return this.jwsStruct.payload();
    }

    record JWSStruct(JsonObject joseHeader, String strJoseHeader, JsonStructure payload, String strPayload) {
        JWSAlgorithm algorithm() {
            String alg = JsonUtils.orElseThrow(this.joseHeader, "alg", JsonString.class).getString();
            if (!ALGO_MAP.containsKey(alg)) {
                throw new RuntimeException(String.format("Unsupported algorithm %s.", alg));
            }
            try {
                return ALGO_MAP.get(alg).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                throw new Error(ex);
            }
        }
    }
}

