/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.json.websignature;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.TracerFactory;
import de.christofreichardt.json.websignature.JWSAlgorithm;
import de.christofreichardt.json.websignature.JWSBase;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;

public class HmacSHA256
implements JWSAlgorithm {
    final Mac mac = Mac.getInstance("HmacSHA256");

    HmacSHA256() throws NoSuchAlgorithmException {
    }

    @Override
    public void init(Key key) throws InvalidKeyException {
        this.mac.init(key);
    }

    @Override
    public void update(byte[] data) {
        this.mac.update(data);
    }

    @Override
    public byte[] signature() {
        return this.mac.doFinal();
    }

    @Override
    public boolean verify(byte[] signature) {
        return MessageDigest.isEqual(this.mac.doFinal(), signature);
    }

    @Override
    public String algorithm() {
        return this.mac.getAlgorithm();
    }

    @Override
    public String postSigning(byte[] signature) {
        return JWSBase.encode(signature);
    }

    @Override
    public byte[] preValidating(byte[] signature) {
        return signature;
    }

    public AbstractTracer getCurrentTracer() {
        return TracerFactory.getInstance().getDefaultTracer();
    }
}

