/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.asn1;

import de.christofreichardt.asn1.ASN1;
import de.christofreichardt.asn1.ASN1Integer;
import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.Traceable;
import java.util.HexFormat;
import java.util.NoSuchElementException;
import java.util.stream.Stream;

public final class ASN1IntSequence
extends ASN1 {
    static final int tag = 48;

    public ASN1IntSequence(byte[] bytes) {
        super(bytes);
        if (this.bytes[0] != 48) {
            throw new IllegalArgumentException("Wrong tag: 0x%02x. ASN.1 SEQUENCE expected.".formatted(bytes[0]));
        }
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public static ASN1IntSequence fromASN1Integers(ASN1Integer ... asn1Integers) {
        int startIndex;
        byte[] encoded;
        int length = Stream.of(asn1Integers).mapToInt(value -> value.asn1Length.rawLength()).sum();
        if (length <= 127) {
            encoded = new byte[length + 2];
            encoded[0] = 48;
            encoded[1] = (byte)length;
            startIndex = 2;
        } else if (length <= 255) {
            encoded = new byte[length + 3];
            encoded[0] = 48;
            encoded[1] = -127;
            encoded[2] = (byte)length;
            startIndex = 3;
        } else {
            throw new UnsupportedOperationException("ToDo.");
        }
        for (ASN1Integer asn1Integer : asn1Integers) {
            System.arraycopy(asn1Integer.encoded(), 0, encoded, startIndex, asn1Integer.asn1Length.rawLength());
            startIndex += asn1Integer.asn1Length.rawLength();
        }
        return new ASN1IntSequence(encoded);
    }

    public String toString() {
        return HexFormat.ofDelimiter(" ").withPrefix("0x").formatHex(this.encoded());
    }

    public class Iterator
    implements java.util.Iterator<ASN1Integer>,
    Traceable {
        int remaining;
        int index;

        public Iterator() {
            this.remaining = ASN1IntSequence.this.asn1Length.rawLength() - ASN1IntSequence.this.asn1Length.startIndex();
            this.index = ASN1IntSequence.this.asn1Length.startIndex();
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ASN1Integer next() {
            AbstractTracer tracer = this.getCurrentTracer();
            tracer.entry("ASN1Integer", (Object)this, "next()");
            try {
                if (this.remaining <= 0) {
                    throw new NoSuchElementException();
                }
                ASN1Integer asn1Integer = new ASN1Integer(ASN1IntSequence.this.bytes, this.index);
                int consumed = asn1Integer.asn1Length.startIndex() + asn1Integer.asn1Length.detectedLength();
                this.remaining -= consumed;
                this.index += consumed;
                ASN1Integer aSN1Integer = asn1Integer;
                return aSN1Integer;
            }
            finally {
                tracer.wayout();
            }
        }

        public AbstractTracer getCurrentTracer() {
            return ASN1IntSequence.this.getCurrentTracer();
        }
    }
}

