/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.asn1;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.Traceable;
import de.christofreichardt.diagnosis.TracerFactory;
import java.util.Arrays;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class ASN1
implements Traceable {
    static final int LENGTH_FORM_DISCRIMINATOR = 128;
    static final int LENGTH_OCTETS_MASK = 127;
    static final int SHORT_LENGTH = 127;
    final byte[] bytes;
    final Length asn1Length;

    ASN1(byte[] bytes) {
        this.bytes = Arrays.copyOf(bytes, bytes.length);
        this.asn1Length = this.length();
    }

    public boolean isShortForm() {
        return this.asn1Length.detectedLength <= 127;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Length length() {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("int", (Object)this, "length()");
        try {
            int startIndex;
            int detectedLength;
            if ((this.bytes[1] & 0x80) == 0) {
                tracer.out().printfIndentln("Short form detected ...", new Object[0]);
                detectedLength = this.bytes[1];
                tracer.out().printfIndentln("detectedLength = %d", new Object[]{detectedLength});
                int actualLength = this.bytes.length - 2;
                if (detectedLength > actualLength) {
                    throw new IllegalArgumentException("Too few bytes (=%d) for detected detectedLength (=%d).".formatted(actualLength, detectedLength));
                }
                startIndex = 2;
            } else {
                tracer.out().printfIndentln("Long form detected ...", new Object[0]);
                int lengthOctets = this.bytes[1] & 0x7F;
                tracer.out().printfIndentln("lengthOctets = %d", new Object[]{lengthOctets});
                if (lengthOctets == 0) {
                    throw new IllegalArgumentException("Number of length octets must not be zero.");
                }
                if (lengthOctets > 1) {
                    throw new UnsupportedOperationException("ToDo.");
                }
                detectedLength = this.bytes[2] & 0xFF;
                tracer.out().printfIndentln("detectedLength = %d", new Object[]{detectedLength});
                int actualLength = this.bytes.length - 3;
                if (detectedLength > actualLength) {
                    throw new IllegalArgumentException("Too few bytes (=%d) for detected detectedLength (=%d).".formatted(actualLength, detectedLength));
                }
                startIndex = 3;
            }
            Length length = new Length(this.bytes.length, detectedLength, startIndex);
            return length;
        }
        finally {
            tracer.wayout();
        }
    }

    public byte[] encoded() {
        return Arrays.copyOfRange(this.bytes, 0, this.asn1Length.detectedLength() + this.asn1Length.startIndex());
    }

    public byte[] actualBytes() {
        return Arrays.copyOfRange(this.bytes, this.asn1Length.startIndex(), this.asn1Length.startIndex() + this.asn1Length.detectedLength());
    }

    public AbstractTracer getCurrentTracer() {
        return TracerFactory.getInstance().getDefaultTracer();
    }

    record Length(int rawLength, int detectedLength, int startIndex) {
    }
}

