/*
 * Decompiled with CFR 0.152.
 */
package de.christianvogt.archunit;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import java.util.Set;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;

class JpaAssociationCondition
extends ArchCondition<JavaClass> {
    private static final String EAGER_ANNOTATION_FOUND_MESSAGE = "Eager annotation found at %s %s";

    JpaAssociationCondition(String description, Object ... args) {
        super(description, args);
    }

    public void check(JavaClass item, ConditionEvents events) {
        this.handleFields(item, events);
        this.handleMethods(item, events);
    }

    private void handleFields(JavaClass item, ConditionEvents events) {
        Set allFields = item.getAllFields();
        allFields.stream().filter(f -> f.tryGetAnnotationOfType(OneToOne.class).isPresent()).filter(f -> !FetchType.LAZY.equals((Object)((OneToOne)f.getAnnotationOfType(OneToOne.class)).fetch())).forEach(a -> events.add((ConditionEvent)this.buildViolationEvent((JavaField)a)));
        allFields.stream().filter(f -> f.tryGetAnnotationOfType(OneToMany.class).isPresent()).filter(f -> !FetchType.LAZY.equals((Object)((OneToMany)f.getAnnotationOfType(OneToMany.class)).fetch())).forEach(a -> events.add((ConditionEvent)this.buildViolationEvent((JavaField)a)));
        allFields.stream().filter(f -> f.tryGetAnnotationOfType(ManyToOne.class).isPresent()).filter(f -> !FetchType.LAZY.equals((Object)((ManyToOne)f.getAnnotationOfType(ManyToOne.class)).fetch())).forEach(a -> events.add((ConditionEvent)this.buildViolationEvent((JavaField)a)));
        allFields.stream().filter(f -> f.tryGetAnnotationOfType(ManyToMany.class).isPresent()).filter(f -> !FetchType.LAZY.equals((Object)((ManyToMany)f.getAnnotationOfType(ManyToMany.class)).fetch())).forEach(a -> events.add((ConditionEvent)this.buildViolationEvent((JavaField)a)));
    }

    private void handleMethods(JavaClass item, ConditionEvents events) {
        Set allMethods = item.getAllMethods();
        allMethods.stream().filter(m -> m.isAnnotatedWith(OneToOne.class)).filter(f -> !FetchType.LAZY.equals((Object)((OneToOne)f.getAnnotationOfType(OneToOne.class)).fetch())).forEach(f -> events.add((ConditionEvent)this.buildViolationEvent((JavaMethod)f)));
        allMethods.stream().filter(m -> m.isAnnotatedWith(OneToMany.class)).filter(f -> !FetchType.LAZY.equals((Object)((OneToMany)f.getAnnotationOfType(OneToMany.class)).fetch())).forEach(f -> events.add((ConditionEvent)this.buildViolationEvent((JavaMethod)f)));
        allMethods.stream().filter(m -> m.isAnnotatedWith(ManyToOne.class)).filter(f -> !FetchType.LAZY.equals((Object)((ManyToOne)f.getAnnotationOfType(ManyToOne.class)).fetch())).forEach(f -> events.add((ConditionEvent)this.buildViolationEvent((JavaMethod)f)));
        allMethods.stream().filter(m -> m.isAnnotatedWith(ManyToMany.class)).filter(f -> !FetchType.LAZY.equals((Object)((ManyToMany)f.getAnnotationOfType(ManyToMany.class)).fetch())).forEach(f -> events.add((ConditionEvent)this.buildViolationEvent((JavaMethod)f)));
    }

    private SimpleConditionEvent buildViolationEvent(JavaField item) {
        return new SimpleConditionEvent((Object)item, false, String.format(EAGER_ANNOTATION_FOUND_MESSAGE, item.getFullName(), item.getSourceCodeLocation().toString()));
    }

    private SimpleConditionEvent buildViolationEvent(JavaMethod method) {
        return new SimpleConditionEvent((Object)method, false, String.format(EAGER_ANNOTATION_FOUND_MESSAGE, method.getFullName(), method.getSourceCodeLocation().toString()));
    }
}

