/*
 * Decompiled with CFR 0.152.
 */
package de.chiflux.tesla;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.chiflux.tesla.TeslaApi;
import de.chiflux.tesla.TeslaToken;
import de.chiflux.tesla.api.ChargeLimitRequest;
import de.chiflux.tesla.api.CmdRespose;
import de.chiflux.tesla.api.FullVehicleData;
import de.chiflux.tesla.api.FullVehicleDataResponse;
import de.chiflux.tesla.api.TokenRefreshRequest;
import de.chiflux.tesla.api.TokenRefreshResponse;
import de.chiflux.tesla.api.VehiclesResponse;
import de.chiflux.tesla.api.WakeUpResponse;
import de.chiflux.utils.ApiRateLimiter;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TeslaLiveApi
implements TeslaApi {
    private static final String TESLA_REFRESH_TOKEN = "TESLA_REFRESH_TOKEN";
    private final ApiRateLimiter rateLimiter = new ApiRateLimiter(1, Duration.ofSeconds(5L), Duration.ofSeconds(2L));
    private static final Logger LOGGER = Logger.getLogger(TeslaLiveApi.class.getName());
    private static final String REFRESH_URL = "https://auth.tesla.com/oauth2/v3/token";
    private static final String BASE_URL = "https://owner-api.teslamotors.com";
    private static final String VEHICLES_URL = "https://owner-api.teslamotors.com/api/1/vehicles";
    private static final String GET_VEHICLE_DATA_URL = "https://owner-api.teslamotors.com/api/1/vehicles/CARID/vehicle_data";
    private static final String GET_VEHICLE_DATA_LOCATION_URL = "https://owner-api.teslamotors.com/api/1/vehicles/CARID/vehicle_data?endpoints=location_data";
    private static final String POST_WAKE_UP_URL = "https://owner-api.teslamotors.com/api/1/vehicles/CARID/wake_up";
    private static final String POST_CHARGE_LIMIT_URL = "https://owner-api.teslamotors.com/api/1/vehicles/CARID/command/set_charge_limit";
    private static final String POST_CHARGE = "https://owner-api.teslamotors.com/api/1/vehicles/CARID/command/charge_";
    private final HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Path teslaSettings = Paths.get("tesla_settings.json", new String[0]);
    private final String teslaRefreshToken;
    private TeslaToken teslaToken = null;

    public TeslaLiveApi(String teslaRefreshToken) {
        if (teslaRefreshToken == null) {
            throw new IllegalArgumentException("teslaRefreshToken must not be null");
        }
        this.teslaRefreshToken = teslaRefreshToken;
        this.init();
    }

    public TeslaLiveApi() {
        String property = System.getProperty(TESLA_REFRESH_TOKEN);
        if (property == null) {
            property = System.getenv(TESLA_REFRESH_TOKEN);
        }
        if (property == null) {
            throw new IllegalStateException("TESLA_REFRESH_TOKEN must not be null");
        }
        this.teslaRefreshToken = property;
        this.init();
    }

    private void init() {
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public Boolean startCharge(String id_s) {
        return this.charge(id_s, "start");
    }

    @Override
    public Boolean stopCharge(String id_s) {
        return this.charge(id_s, "stop");
    }

    private Boolean charge(String id_s, String cmd) {
        try {
            this.refreshToken();
            String url = (POST_CHARGE + cmd).replace("CARID", id_s);
            HttpRequest request = HttpRequest.newBuilder().uri(new URI(url)).header("Authorization", "Bearer " + this.teslaToken.accessToken()).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString("{}")).timeout(Duration.ofMinutes(1L)).build();
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            int code = response.statusCode();
            if (code < 200 || code >= 300) {
                LOGGER.warning("Error charge vehicle status code: " + code);
                throw new IllegalStateException("code=" + code);
            }
            return this.processCMDResponse(response.body());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            return false;
        }
    }

    private Boolean processCMDResponse(String response) throws IOException {
        byte[] bytes = response.getBytes(StandardCharsets.UTF_8);
        CmdRespose cmdResponse = (CmdRespose)this.objectMapper.readValue(bytes, CmdRespose.class);
        LOGGER.finer("CmdResponse: " + String.valueOf(cmdResponse));
        return cmdResponse.response().result();
    }

    @Override
    public Boolean setChargeLimit(String id_s, int chargeLimit) {
        if (id_s == null || id_s.isBlank()) {
            LOGGER.warning("setChargeLimit id_s is not set");
            return false;
        }
        try {
            this.refreshToken();
            String url = POST_CHARGE_LIMIT_URL.replace("CARID", id_s);
            String json = this.objectMapper.writeValueAsString((Object)new ChargeLimitRequest(chargeLimit));
            HttpRequest request = HttpRequest.newBuilder().uri(new URI(url)).header("Authorization", "Bearer " + this.teslaToken.accessToken()).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(json)).timeout(Duration.ofMinutes(1L)).build();
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            int code = response.statusCode();
            if (code < 200 || code >= 300) {
                LOGGER.warning("Error setChargeLimit to " + chargeLimit + " status code: " + code);
                throw new IllegalStateException("code=" + code);
            }
            return this.processCMDResponse(response.body());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            return false;
        }
    }

    @Override
    public Boolean wakeUp(String id_s) {
        try {
            this.refreshToken();
            String url = POST_WAKE_UP_URL.replace("CARID", id_s);
            HttpRequest request = HttpRequest.newBuilder().uri(new URI(url)).header("Authorization", "Bearer " + this.teslaToken.accessToken()).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString("{}")).timeout(Duration.ofMinutes(1L)).build();
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            int code = response.statusCode();
            if (code < 200 || code >= 300) {
                LOGGER.warning("Error waking up vehicle status code: " + code);
            } else {
                byte[] bytes = response.body().getBytes(StandardCharsets.UTF_8);
                WakeUpResponse wakeUpResponse = (WakeUpResponse)this.objectMapper.readValue(bytes, WakeUpResponse.class);
                LOGGER.finer("WakeUpResponse: " + String.valueOf(wakeUpResponse));
                String state = wakeUpResponse.response().state();
                if (!state.equals("asleep")) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
        return false;
    }

    private FullVehicleData getFullVehicleDataInternal(String url) {
        try {
            LOGGER.log(Level.FINE, "query url: " + url);
            HttpRequest request = HttpRequest.newBuilder().uri(new URI(url)).header("Authorization", "Bearer " + this.teslaToken.accessToken()).header("Content-Type", "application/json").GET().timeout(Duration.ofMinutes(1L)).build();
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            int code = response.statusCode();
            if (code < 200 || code >= 300) {
                if (code == 408) {
                    LOGGER.log(Level.WARNING, "status code 408");
                }
                if (code == 429) {
                    int slowdownInPercent = 10;
                    LOGGER.log(Level.WARNING, "status code 429: slowing down request frequency by " + slowdownInPercent + "%");
                    this.rateLimiter.slowdown(slowdownInPercent);
                }
                return null;
            }
            byte[] bytes = response.body().getBytes(StandardCharsets.UTF_8);
            FullVehicleDataResponse fullVehicleDataResponse = (FullVehicleDataResponse)this.objectMapper.readValue(bytes, FullVehicleDataResponse.class);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "unmarshalled json response: " + String.valueOf(fullVehicleDataResponse));
            }
            return fullVehicleDataResponse.response();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public FullVehicleData getFullVehicleData(String id_s) {
        try {
            this.refreshToken();
            FullVehicleData fullVehicleData = this.getFullVehicleDataInternal(GET_VEHICLE_DATA_URL.replace("CARID", id_s));
            if (fullVehicleData == null) {
                return null;
            }
            FullVehicleData fullVehicleDataWithLocation = this.getFullVehicleDataInternal(GET_VEHICLE_DATA_LOCATION_URL.replace("CARID", id_s));
            if (fullVehicleDataWithLocation == null) {
                return null;
            }
            return fullVehicleData.withDriveState(fullVehicleDataWithLocation.drive_state());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    @Override
    public VehiclesResponse getVehicles() {
        try {
            this.refreshToken();
            String url = VEHICLES_URL;
            HttpRequest request = HttpRequest.newBuilder().uri(new URI(url)).header("Authorization", "Bearer " + this.teslaToken.accessToken()).header("Content-Type", "application/json").GET().timeout(Duration.ofMinutes(1L)).build();
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            int code = response.statusCode();
            if (code < 200 || code >= 300) {
                if (code == 408) {
                    LOGGER.log(Level.WARNING, "status code 408");
                }
                if (code == 429) {
                    int slowdownInPercent = 10;
                    LOGGER.log(Level.WARNING, "status code 429: slowing down request frequency by " + slowdownInPercent + "%");
                    this.rateLimiter.slowdown(slowdownInPercent);
                }
                throw new IllegalStateException("code=" + code);
            }
            byte[] bytes = response.body().getBytes(StandardCharsets.UTF_8);
            VehiclesResponse vehiclesResponse = (VehiclesResponse)this.objectMapper.readValue(bytes, VehiclesResponse.class);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "unmarshalled json response: " + String.valueOf(vehiclesResponse));
            }
            return vehiclesResponse;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized void refreshToken() {
        this.rateLimiter.acquireWait();
        try {
            TeslaToken teslaToken;
            if (this.teslaToken != null && this.teslaToken.isValid()) {
                return;
            }
            ObjectMapper objectMapper = new ObjectMapper();
            if (Files.exists(this.teslaSettings, new LinkOption[0])) {
                try {
                    byte[] bytes = Files.readAllBytes(this.teslaSettings);
                    TeslaToken teslaToken2 = (TeslaToken)objectMapper.readValue(bytes, TeslaToken.class);
                    if (teslaToken2.isValid()) {
                        this.teslaToken = teslaToken2;
                        return;
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, e.getMessage(), e);
                }
            }
            this.rateLimiter.acquireWait();
            String url = REFRESH_URL;
            String json = objectMapper.writeValueAsString((Object)new TokenRefreshRequest(this.teslaRefreshToken));
            HttpRequest request = HttpRequest.newBuilder().uri(new URI(url)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(json)).timeout(Duration.ofMinutes(1L)).build();
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            int code = response.statusCode();
            LOGGER.log(Level.FINE, "status code=" + code + " url=" + url);
            String responseBody = response.body();
            if (responseBody == null) {
                throw new IllegalStateException("responseBody is null");
            }
            byte[] bytes = responseBody.getBytes(StandardCharsets.UTF_8);
            TokenRefreshResponse tokenRefreshResponse = (TokenRefreshResponse)objectMapper.readValue(bytes, TokenRefreshResponse.class);
            this.teslaToken = teslaToken = new TeslaToken(tokenRefreshResponse.access_token(), tokenRefreshResponse.expires());
            Files.writeString(this.teslaSettings, (CharSequence)objectMapper.writeValueAsString((Object)teslaToken), new OpenOption[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

