/*
 * Decompiled with CFR 0.152.
 */
package de.chiflux.tesla;

import de.chiflux.tesla.BasicVehicleInfo;
import de.chiflux.tesla.ExtendedVehicleInfo;
import de.chiflux.tesla.StateChangeInfo;
import de.chiflux.tesla.TeslaApi;
import de.chiflux.tesla.TeslaApiDefines;
import de.chiflux.tesla.TeslaLiveApi;
import de.chiflux.tesla.VehicleInfo;
import de.chiflux.tesla.api.FullVehicleData;
import de.chiflux.tesla.api.VehicleData;
import de.chiflux.tesla.api.VehiclesResponse;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TeslaApiService
implements TeslaApi {
    private static final Logger LOGGER = Logger.getLogger(TeslaLiveApi.class.getName());
    private static TeslaApiService INSTANCE = null;
    private final Map<String, Instant> INACTIVE_MAP = new ConcurrentHashMap<String, Instant>();
    private final ConcurrentHashMap<String, Instant> LAST_BASIC_VEHICLE_INFO_TS = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, BasicVehicleInfo> LAST_BASIC_VEHICLE_INFO = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Instant> LAST_EXTENDED_VEHICLE_INFO_TS = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ExtendedVehicleInfo> LAST_EXTENDED_VEHICLE_INFO = new ConcurrentHashMap();
    public final SynchronousQueue<StateChangeInfo> STATE_CHANGE_INFO_QUEUE = new SynchronousQueue();
    private static final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
    private static final AtomicBoolean PAUSED = new AtomicBoolean(true);
    private final TeslaApi teslaApi = TeslaApi.getLiveApi();

    public static synchronized TeslaApiService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TeslaApiService();
        }
        return INSTANCE;
    }

    public void markVehicleInactive(String id) {
        if (!this.INACTIVE_MAP.containsKey(id)) {
            Instant now = Instant.now();
            this.INACTIVE_MAP.put(id, now);
            LOGGER.log(Level.FINE, "vehicle " + id + " marked INACTIVE instant=" + String.valueOf(now));
            LOGGER.log(Level.FINE, "INACTIVE_MAP (2): " + String.valueOf(this.INACTIVE_MAP));
        }
    }

    public void unmuteVehicle(String id_s) {
        if (id_s == null) {
            return;
        }
        this.INACTIVE_MAP.remove(id_s);
        LOGGER.info("UNMUTED vehicle " + id_s);
    }

    public boolean isMute(String id_s) {
        Instant instant = this.INACTIVE_MAP.get(id_s);
        if (instant != null) {
            Instant now = Instant.now();
            return now.isBefore(instant.plus(20L, ChronoUnit.MINUTES)) && now.isAfter(instant.plus(3L, ChronoUnit.MINUTES));
        }
        return false;
    }

    private TeslaApiService() {
        Runnable task = () -> {
            try {
                if (!PAUSED.get()) {
                    Instant i1 = Instant.now();
                    VehiclesResponse vehicles = this.getVehicles();
                    Instant i2 = Instant.now();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.INFO, "getVehicles took: " + String.valueOf(Duration.between(i1, i2)) + ", data: " + String.valueOf(vehicles));
                    }
                    List<VehicleData> vehicleDataList = vehicles.response();
                    for (VehicleData vehicleData : vehicleDataList) {
                        boolean stateChange = false;
                        BasicVehicleInfo basicVehicleInfo = VehicleInfo.ofVehicleData(vehicleData);
                        String id = basicVehicleInfo.id();
                        String state = basicVehicleInfo.state();
                        String vehicleName = basicVehicleInfo.vehicleName();
                        VehicleInfo oldBasicVehicleInfo = this.LAST_BASIC_VEHICLE_INFO.put(id, basicVehicleInfo);
                        this.LAST_BASIC_VEHICLE_INFO_TS.put(id, Instant.now());
                        if (!basicVehicleInfo.equals(oldBasicVehicleInfo)) {
                            stateChange = true;
                            this.unmuteVehicle(id);
                            LOGGER.log(Level.INFO, "basic state change detected");
                        }
                        if (state.equals(TeslaApiDefines.TESLA_STATE.online.name())) {
                            i1 = Instant.now();
                            FullVehicleData fullVehicleData = this.getFullVehicleData(id);
                            i2 = Instant.now();
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.log(Level.INFO, "getFullVehicleData from " + vehicleName + " took: " + String.valueOf(Duration.between(i1, i2)) + ", fullVehicleData: " + String.valueOf(fullVehicleData));
                            }
                            this.handleSleepTry(vehicleData, fullVehicleData);
                            if (fullVehicleData == null) {
                                if (stateChange) {
                                    this.callStateChangeListeners(id);
                                }
                                return;
                            }
                            ExtendedVehicleInfo extendedVehicleInfo = VehicleInfo.ofFullVehicleData(fullVehicleData);
                            ExtendedVehicleInfo oldExtendedVehicleInfo = this.LAST_EXTENDED_VEHICLE_INFO.put(id, extendedVehicleInfo);
                            this.LAST_EXTENDED_VEHICLE_INFO_TS.put(id, Instant.now());
                            if (!extendedVehicleInfo.equals(oldExtendedVehicleInfo)) {
                                stateChange = true;
                                LOGGER.log(Level.INFO, "extended state change detected");
                            }
                        }
                        if (!stateChange) continue;
                        this.callStateChangeListeners(id);
                    }
                }
            }
            catch (InterruptedException | RuntimeException e) {
                LOGGER.log(Level.INFO, e.getMessage());
                LOGGER.log(Level.FINE, e.getMessage(), e);
            }
        };
        executor.scheduleAtFixedRate(task, 2L, 15L, TimeUnit.SECONDS);
    }

    private void callStateChangeListeners(String id) throws InterruptedException {
        this.unmuteVehicle(id);
        BasicVehicleInfo basicVehicleInfo = this.LAST_BASIC_VEHICLE_INFO.get(id);
        Instant basicVehicleInfoTimestamp = this.LAST_BASIC_VEHICLE_INFO_TS.get(id);
        ExtendedVehicleInfo extendedVehicleInfo = this.LAST_EXTENDED_VEHICLE_INFO.get(id);
        Instant extendedVehicleInfoTimestamp = this.LAST_EXTENDED_VEHICLE_INFO_TS.get(id);
        if (basicVehicleInfo != null || extendedVehicleInfo != null) {
            StateChangeInfo stateChangeInfo = new StateChangeInfo(basicVehicleInfoTimestamp, basicVehicleInfo, extendedVehicleInfoTimestamp, extendedVehicleInfo);
            this.STATE_CHANGE_INFO_QUEUE.put(stateChangeInfo);
        }
    }

    private void handleSleepTry(VehicleData vehicleData, FullVehicleData fullVehicleData) {
        if (vehicleData == null || fullVehicleData == null) {
            return;
        }
        String state = vehicleData.state();
        String id = vehicleData.id_s();
        String vehicleName = vehicleData.display_name();
        boolean tryToSleep = false;
        if (state.equals(TeslaApiDefines.TESLA_STATE.online.name())) {
            Boolean locked = fullVehicleData.vehicle_state().locked();
            String shiftState = fullVehicleData.drive_state().shift_state();
            boolean shiftStateParked = shiftState == null || shiftState.equals("P");
            LOGGER.log(Level.FINE, "locked: " + locked);
            LOGGER.log(Level.FINE, "shiftStateParked: " + shiftStateParked);
            boolean charging = fullVehicleData.charge_state().charging_state().equalsIgnoreCase(TeslaApiDefines.CHARGE_STATE.Charging.name());
            if (shiftStateParked && locked.booleanValue() && !charging) {
                tryToSleep = true;
                LOGGER.log(Level.FINE, "INACTIVE_MAP (1): " + String.valueOf(this.INACTIVE_MAP));
                if (!this.INACTIVE_MAP.containsKey(id)) {
                    LOGGER.log(Level.INFO, "Vehicle is parked and locked => try to let car fall asleep: " + id + " (" + vehicleName + ") at " + String.valueOf(Instant.now()));
                    this.markVehicleInactive(id);
                }
            }
        }
        if (!tryToSleep) {
            LOGGER.log(Level.FINE, "removing car " + id + " (" + vehicleName + ") from try to fall asleep list");
            this.unmuteVehicle(id);
        }
    }

    public void startService() {
        PAUSED.set(false);
    }

    public void pauseService() {
        PAUSED.set(true);
    }

    public void endService() {
        executor.shutdown();
    }

    @Override
    public Boolean startCharge(String id_s) {
        return this.teslaApi.startCharge(id_s);
    }

    @Override
    public Boolean stopCharge(String id_s) {
        return this.teslaApi.stopCharge(id_s);
    }

    @Override
    public Boolean setChargeLimit(String id_s, int chargeLimit) {
        return this.teslaApi.setChargeLimit(id_s, chargeLimit);
    }

    @Override
    public Boolean wakeUp(String id_s) {
        this.unmuteVehicle(id_s);
        return this.teslaApi.wakeUp(id_s);
    }

    @Override
    public FullVehicleData getFullVehicleData(String id) {
        if (this.isMute(id)) {
            LOGGER.info("car " + id + " is muted!");
            return null;
        }
        return this.teslaApi.getFullVehicleData(id);
    }

    @Override
    public VehiclesResponse getVehicles() {
        return this.teslaApi.getVehicles();
    }

    @Override
    public void refreshToken() {
        this.teslaApi.refreshToken();
    }
}

